<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserArabicController;

// مسارات إدارة المستخدمين باللغة العربية
Route::middleware(['auth', 'company.session'])->group(function () {
    Route::get('/users/arabic', [UserArabicController::class, 'index'])->name('users.arabic.index');
    Route::get('/users/arabic/create', [UserArabicController::class, 'create'])->name('users.arabic.create');
    Route::post('/users/arabic', [UserArabicController::class, 'store'])->name('users.arabic.store');
    Route::get('/users/arabic/{user}', [UserArabicController::class, 'show'])->name('users.arabic.show');
    Route::get('/users/arabic/{user}/edit', [UserArabicController::class, 'edit'])->name('users.arabic.edit');
    Route::put('/users/arabic/{user}', [UserArabicController::class, 'update'])->name('users.arabic.update');
    Route::delete('/users/arabic/{user}', [UserArabicController::class, 'destroy'])->name('users.arabic.destroy');
    Route::patch('/users/arabic/{user}/toggle-status', [UserArabicController::class, 'toggleStatus'])->name('users.arabic.toggle-status');
});
