<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\FinancialReportController;

/*
|--------------------------------------------------------------------------
| API Routes for Reports
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for reports
|
*/

// مسارات التقارير المالية
Route::prefix('reports')->middleware(['auth:sanctum'])->group(function () {
    Route::get('/revenue', [FinancialReportController::class, 'revenueReport']);
    Route::get('/payments', [FinancialReportController::class, 'paymentsReport']);
    Route::get('/contracts', [FinancialReportController::class, 'contractsReport']);
    Route::get('/accounts-receivable', [FinancialReportController::class, 'accountsReceivableReport']);
    Route::get('/customer-statement', [FinancialReportController::class, 'customerStatementReport']);
});
