<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\CustomerController;
use App\Http\Controllers\API\MaintenanceLogController;
use App\Http\Controllers\API\MaintenanceScheduleController;

/*
|--------------------------------------------------------------------------
| API Routes for Maintenance
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for maintenance management
|
*/

// مسارات سجلات الصيانة
Route::prefix('maintenance-logs')->middleware(['auth:sanctum'])->group(function () {
    Route::get('/', [MaintenanceLogController::class, 'index']);
    Route::post('/', [MaintenanceLogController::class, 'store']);
    Route::get('/{id}', [MaintenanceLogController::class, 'show']);
    Route::put('/{id}', [MaintenanceLogController::class, 'update']);
    Route::delete('/{id}', [MaintenanceLogController::class, 'destroy']);
    Route::get('/statistics', [MaintenanceLogController::class, 'statistics']);
});

// مسارات جدولة الصيانة
Route::prefix('maintenance-schedules')->middleware(['auth:sanctum'])->group(function () {
    Route::get('/', [MaintenanceScheduleController::class, 'index']);
    Route::post('/', [MaintenanceScheduleController::class, 'store']);
    Route::get('/{id}', [MaintenanceScheduleController::class, 'show']);
    Route::put('/{id}', [MaintenanceScheduleController::class, 'update']);
    Route::delete('/{id}', [MaintenanceScheduleController::class, 'destroy']);
    Route::post('/generate-for-contract', [MaintenanceScheduleController::class, 'generateScheduleForContract']);
    Route::get('/monthly', [MaintenanceScheduleController::class, 'getMonthlySchedule']);
});

// مسارات العملاء
Route::prefix('customer')->middleware(['auth'])->group(function () {
    Route::get('/elevators', [CustomerController::class, 'getElevators'])->name('api.customer.elevators');
});
