<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\InvoiceInstallmentController;

/*
|--------------------------------------------------------------------------
| API Routes for Invoice Installments
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for invoice installments
|
*/

Route::middleware(['auth:sanctum'])->group(function () {
    // مسارات الأقساط
    Route::get('/installments', [InvoiceInstallmentController::class, 'index']);
    Route::post('/installments', [InvoiceInstallmentController::class, 'store']);
    Route::get('/installments/{id}', [InvoiceInstallmentController::class, 'show']);
    Route::put('/installments/{id}', [InvoiceInstallmentController::class, 'update']);
    Route::delete('/installments/{id}', [InvoiceInstallmentController::class, 'destroy']);

    // تسجيل دفعة لقسط
    Route::post('/installments/{id}/payments', [InvoiceInstallmentController::class, 'recordPayment']);

    // الأقساط المستحقة قريباً
    Route::get('/installments/reports/upcoming', [InvoiceInstallmentController::class, 'upcoming']);

    // الأقساط المتأخرة
    Route::get('/installments/reports/overdue', [InvoiceInstallmentController::class, 'overdue']);

    // إحصائيات الأقساط
    Route::get('/installments/stats', [InvoiceInstallmentController::class, 'stats']);

    // إنشاء أقساط تلقائية للفاتورة
    Route::post('/invoices/{invoice_id}/installments/auto-create', [InvoiceInstallmentController::class, 'createInstallmentsForInvoice']);
});
