<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\MaintenanceFinancialReportController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// مسارات التقارير المالية للصيانة
Route::middleware('auth:sanctum')->group(function () {
    Route::prefix('maintenance-financial')->group(function () {
        Route::post('/report', [MaintenanceFinancialReportController::class, 'getFinancialReport']);
        Route::post('/technician-performance', [MaintenanceFinancialReportController::class, 'getTechnicianPerformanceReport']);
        Route::post('/generate-invoices', [MaintenanceFinancialReportController::class, 'generateInvoicesFromMaintenance']);
    });
});

// تضمين مسارات الصيانة
require __DIR__ . '/api_maintenance.php';

// تضمين مسارات التقارير
require __DIR__ . '/api_reports.php';
