<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Advanced Notifications Routes
|--------------------------------------------------------------------------
|
| هنا يتم تعريف مسارات نظام الإشعارات المتقدم
|
*/

// مسارات الإشعارات العاجلة
Route::get('/urgent-notifications', function () {
    return view('notifications.urgent');
})->name('notifications.urgent')->middleware('permission:view_urgent_notifications');

// مسارات إعدادات الإشعارات
Route::prefix('notification-settings')->name('notification-settings.')->middleware('permission:manage_notification_settings')->group(function () {
    Route::get('/', function () {
        return view('notifications.settings.index');
    })->name('index');

    Route::get('/edit/{id}', function ($id) {
        return view('notifications.settings.edit', ['id' => $id]);
    })->name('edit');

    Route::post('/update/{id}', function ($id) {
        // تحديث إعدادات الإشعارات
        return redirect()->route('notification-settings.index')->with('success', 'تم تحديث الإعدادات بنجاح');
    })->name('update');
});

// مسارات سجلات الإشعارات
Route::prefix('notification-logs')->name('notification-logs.')->middleware('permission:view_notification_logs')->group(function () {
    Route::get('/', function () {
        return view('notifications.logs.index');
    })->name('index');

    Route::get('/show/{id}', function ($id) {
        return view('notifications.logs.show', ['id' => $id]);
    })->name('show');

    Route::get('/export', function () {
        // تصدير سجلات الإشعارات
        return redirect()->route('notification-logs.index')->with('success', 'تم تصدير السجلات بنجاح');
    })->name('export')->middleware('permission:export_notifications');
});

// مسار تشغيل فحص الصيانة
Route::get('/run-maintenance-notifications', function () {
    // تشغيل فحص الصيانة وإرسال الإشعارات
    return redirect()->route('notifications.index')->with('success', 'تم تشغيل فحص الصيانة وإرسال الإشعارات بنجاح');
})->name('notifications.run-maintenance-check')->middleware('permission:run_maintenance_notifications');
