<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ChartOfAccountController;
use App\Http\Controllers\JournalEntryController;
use App\Http\Controllers\FiscalYearController;
use App\Http\Controllers\AccountingPeriodController;
use App\Http\Controllers\JournalTemplateController;
use App\Http\Controllers\FinancialStatementController;
use App\Http\Controllers\CashRegisterController;
use App\Http\Controllers\CashTransactionController;
use App\Http\Controllers\AccountLedgerController;
use App\Http\Controllers\AccountBalanceReportController;

/*
|--------------------------------------------------------------------------
| Accounting Routes
|--------------------------------------------------------------------------
|
| Here is where you can register accounting related routes for your application.
|
*/

// مسارات النظام المحاسبي
Route::group(['middleware' => ['auth']], function () {
    // لوحة التحكم المحاسبية
    Route::get('accounting/dashboard', function () {
        return view('accounting.dashboard');
    })->name('accounting.dashboard')->middleware('permission:view_accounting_dashboard');

    // مسارات دليل الحسابات
    Route::get('chart-of-accounts', [ChartOfAccountController::class, 'index'])->name('chart-of-accounts.index')->middleware('permission:view_chart_of_accounts');
    Route::get('chart-of-accounts/create', [ChartOfAccountController::class, 'create'])->name('chart-of-accounts.create')->middleware('permission:create_chart_of_accounts');
    Route::post('chart-of-accounts', [ChartOfAccountController::class, 'store'])->name('chart-of-accounts.store')->middleware('permission:create_chart_of_accounts');
    Route::get('chart-of-accounts/tree', [ChartOfAccountController::class, 'tree'])->name('chart-of-accounts.tree')->middleware('permission:view_chart_of_accounts');
    // المسارات التي تحتوي على متغيرات يجب أن تكون بعد المسارات المحددة
    Route::get('chart-of-accounts/{account}', [ChartOfAccountController::class, 'show'])->name('chart-of-accounts.show')->middleware('permission:view_chart_of_accounts');
    Route::get('chart-of-accounts/{account}/edit', [ChartOfAccountController::class, 'edit'])->name('chart-of-accounts.edit')->middleware('permission:edit_chart_of_accounts');
    Route::put('chart-of-accounts/{account}', [ChartOfAccountController::class, 'update'])->name('chart-of-accounts.update')->middleware('permission:edit_chart_of_accounts');
    Route::delete('chart-of-accounts/{account}', [ChartOfAccountController::class, 'destroy'])->name('chart-of-accounts.destroy')->middleware('permission:delete_chart_of_accounts');
    Route::get('trial-balance', [ChartOfAccountController::class, 'trialBalance'])->name('chart-of-accounts.trial-balance')->middleware('permission:view_accounting_reports');

    // مسارات القيود المحاسبية
    Route::get('journal-entries', [JournalEntryController::class, 'index'])->name('journal-entries.index')->middleware('permission:view_journal_entries');
    Route::get('journal-entries/create', [JournalEntryController::class, 'create'])->name('journal-entries.create')->middleware('permission:create_journal_entries');
    Route::post('journal-entries', [JournalEntryController::class, 'store'])->name('journal-entries.store')->middleware('permission:create_journal_entries');
    Route::get('journal-entries/{entry}', [JournalEntryController::class, 'show'])->name('journal-entries.show')->middleware('permission:view_journal_entries');
    Route::get('journal-entries/{entry}/edit', [JournalEntryController::class, 'edit'])->name('journal-entries.edit')->middleware('permission:edit_journal_entries');
    Route::put('journal-entries/{entry}', [JournalEntryController::class, 'update'])->name('journal-entries.update')->middleware('permission:edit_journal_entries');
    Route::delete('journal-entries/{entry}', [JournalEntryController::class, 'destroy'])->name('journal-entries.destroy')->middleware('permission:delete_journal_entries');
    Route::post('journal-entries/{entry}/post', [JournalEntryController::class, 'post'])->name('journal-entries.post')->middleware('permission:post_journal_entries');
    Route::post('journal-entries/{entry}/unpost', [JournalEntryController::class, 'unpost'])->name('journal-entries.unpost')->middleware('permission:post_journal_entries');
    Route::post('journal-entries/{entry}/approve', [JournalEntryController::class, 'approve'])->name('journal-entries.approve')->middleware('permission:approve_journal_entries');
    Route::post('journal-entries/{entry}/unapprove', [JournalEntryController::class, 'unapprove'])->name('journal-entries.unapprove')->middleware('permission:approve_journal_entries');
    Route::get('journal-entries/{entry}/print', [JournalEntryController::class, 'print'])->name('journal-entries.print')->middleware('permission:view_journal_entries');

    // مسارات السنوات المالية
    Route::get('fiscal-years', [FiscalYearController::class, 'index'])->name('fiscal-years.index')->middleware('permission:view_fiscal_years');
    Route::get('fiscal-years/create', [FiscalYearController::class, 'create'])->name('fiscal-years.create')->middleware('permission:create_fiscal_years');
    Route::post('fiscal-years', [FiscalYearController::class, 'store'])->name('fiscal-years.store')->middleware('permission:create_fiscal_years');
    Route::get('fiscal-years/{fiscalYear}', [FiscalYearController::class, 'show'])->name('fiscal-years.show')->middleware('permission:view_fiscal_years');
    Route::get('fiscal-years/{fiscalYear}/edit', [FiscalYearController::class, 'edit'])->name('fiscal-years.edit')->middleware('permission:edit_fiscal_years');
    Route::put('fiscal-years/{fiscalYear}', [FiscalYearController::class, 'update'])->name('fiscal-years.update')->middleware('permission:edit_fiscal_years');
    Route::post('fiscal-years/{fiscalYear}/close', [FiscalYearController::class, 'close'])->name('fiscal-years.close')->middleware('permission:close_fiscal_years');
    Route::post('fiscal-years/{fiscalYear}/reopen', [FiscalYearController::class, 'reopen'])->name('fiscal-years.reopen')->middleware('permission:close_fiscal_years');

    // مسارات الفترات المحاسبية
    Route::get('accounting-periods', [AccountingPeriodController::class, 'index'])->name('accounting-periods.index')->middleware('permission:view_accounting_periods');
    Route::get('accounting-periods/create', [AccountingPeriodController::class, 'create'])->name('accounting-periods.create')->middleware('permission:create_accounting_periods');
    Route::post('accounting-periods', [AccountingPeriodController::class, 'store'])->name('accounting-periods.store')->middleware('permission:create_accounting_periods');
    Route::get('accounting-periods/{period}', [AccountingPeriodController::class, 'show'])->name('accounting-periods.show')->middleware('permission:view_accounting_periods');
    Route::get('accounting-periods/{period}/edit', [AccountingPeriodController::class, 'edit'])->name('accounting-periods.edit')->middleware('permission:edit_accounting_periods');
    Route::put('accounting-periods/{period}', [AccountingPeriodController::class, 'update'])->name('accounting-periods.update')->middleware('permission:edit_accounting_periods');
    Route::post('accounting-periods/{period}/close', [AccountingPeriodController::class, 'close'])->name('accounting-periods.close')->middleware('permission:close_accounting_periods');
    Route::post('accounting-periods/{period}/reopen', [AccountingPeriodController::class, 'reopen'])->name('accounting-periods.reopen')->middleware('permission:close_accounting_periods');

    // مسارات قوالب القيود المحاسبية
    Route::get('journal-templates', [JournalTemplateController::class, 'index'])->name('journal-templates.index')->middleware('permission:view_journal_templates');
    Route::get('journal-templates/create', [JournalTemplateController::class, 'create'])->name('journal-templates.create')->middleware('permission:create_journal_templates');
    Route::post('journal-templates', [JournalTemplateController::class, 'store'])->name('journal-templates.store')->middleware('permission:create_journal_templates');
    Route::get('journal-templates/{template}', [JournalTemplateController::class, 'show'])->name('journal-templates.show')->middleware('permission:view_journal_templates');
    Route::get('journal-templates/{template}/edit', [JournalTemplateController::class, 'edit'])->name('journal-templates.edit')->middleware('permission:edit_journal_templates');
    Route::put('journal-templates/{template}', [JournalTemplateController::class, 'update'])->name('journal-templates.update')->middleware('permission:edit_journal_templates');
    Route::delete('journal-templates/{template}', [JournalTemplateController::class, 'destroy'])->name('journal-templates.destroy')->middleware('permission:delete_journal_templates');
    Route::get('journal-templates/{template}/create-entry', [JournalTemplateController::class, 'createEntry'])->name('journal-templates.create-entry')->middleware('permission:create_journal_entries');
    Route::post('journal-templates/{template}/store-entry', [JournalTemplateController::class, 'storeEntry'])->name('journal-templates.store-entry')->middleware('permission:create_journal_entries');

    // مسارات التقارير المالية
    Route::get('financial-statements/income-statement', [FinancialStatementController::class, 'incomeStatement'])->name('financial-statements.income-statement')->middleware('permission:view_accounting_reports');
    Route::get('financial-statements/balance-sheet', [FinancialStatementController::class, 'balanceSheet'])->name('financial-statements.balance-sheet')->middleware('permission:view_accounting_reports');
    Route::get('financial-statements/cash-flow', [FinancialStatementController::class, 'cashFlow'])->name('financial-statements.cash-flow')->middleware('permission:view_accounting_reports');
    Route::get('financial-statements/equity-changes', [FinancialStatementController::class, 'equityChanges'])->name('financial-statements.equity-changes')->middleware('permission:view_accounting_reports');
    Route::post('financial-statements/export', [FinancialStatementController::class, 'export'])->name('financial-statements.export')->middleware('permission:view_accounting_reports');

    // ربط الخزائن بالحسابات
    Route::get('cash-registers/{cashRegister}/link-account', [CashRegisterController::class, 'linkAccountForm'])->name('cash-registers.link-account-form')->middleware('permission:edit_cash_registers');
    Route::post('cash-registers/{cashRegister}/link-account', [CashRegisterController::class, 'linkAccount'])->name('cash-registers.link-account')->middleware('permission:edit_cash_registers');
    Route::delete('cash-registers/{cashRegister}/unlink-account/{account}', [CashRegisterController::class, 'unlinkAccount'])->name('cash-registers.unlink-account')->middleware('permission:edit_cash_registers');

    // إنشاء قيد محاسبي من معاملة خزينة
    Route::get('cash-transactions/{cashTransaction}/create-journal-entry', [CashTransactionController::class, 'createJournalEntry'])->name('cash-transactions.create-journal-entry')->middleware('permission:create_journal_entries');
    Route::post('cash-transactions/{cashTransaction}/store-journal-entry', [CashTransactionController::class, 'storeJournalEntry'])->name('cash-transactions.store-journal-entry')->middleware('permission:create_journal_entries');

    // مسارات دفتر الأستاذ (كشف الحساب)
    Route::get('ledger', [AccountLedgerController::class, 'index'])->name('ledger.index')->middleware('permission:view_accounting_reports');
    Route::get('ledger/show', [AccountLedgerController::class, 'show'])->name('ledger.show')->middleware('permission:view_accounting_reports');
    Route::get('ledger/print', [AccountLedgerController::class, 'print'])->name('ledger.print')->middleware('permission:view_accounting_reports');

    // مسارات تقرير أرصدة الحسابات
    Route::get('account-balance-report', [AccountBalanceReportController::class, 'index'])->name('account-balance-report.index')->middleware('permission:view_accounting_reports');
    Route::get('account-balance-report/export', [AccountBalanceReportController::class, 'export'])->name('account-balance-report.export')->middleware('permission:view_accounting_reports');
});
