@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">تفاصيل الفاتورة الإلكترونية - {{ $invoice->invoice_number }}</h4>
                    <a href="{{ route('zatca.index') }}" class="btn btn-light">
                        <i class="fa fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-info text-white">
                                    معلومات الفاتورة الأساسية
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>رقم الفاتورة</th>
                                            <td>{{ $invoice->invoice_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الفاتورة</th>
                                            <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>{{ $invoice->customer->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ الإجمالي</th>
                                            <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>مبلغ الضريبة</th>
                                            <td>{{ number_format($invoice->tax_amount, 2) }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-primary text-white">
                                    معلومات الفوترة الإلكترونية
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('zatca.update-type', $invoice->id) }}" method="POST" class="mb-3">
                                        @csrf
                                        <div class="form-group row">
                                            <label for="zatca_invoice_type" class="col-sm-4 col-form-label">نوع الفاتورة</label>
                                            <div class="col-sm-8">
                                                <select name="zatca_invoice_type" id="zatca_invoice_type" class="form-control">
                                                    <option value="standard" {{ $invoice->zatca_invoice_type == 'standard' ? 'selected' : '' }}>قياسية</option>
                                                    <option value="simplified" {{ $invoice->zatca_invoice_type == 'simplified' ? 'selected' : '' }}>مبسطة</option>
                                                    <option value="debit_note" {{ $invoice->zatca_invoice_type == 'debit_note' ? 'selected' : '' }}>إشعار مدين</option>
                                                    <option value="credit_note" {{ $invoice->zatca_invoice_type == 'credit_note' ? 'selected' : '' }}>إشعار دائن</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <div class="col-sm-12 text-right">
                                                <button type="submit" class="btn btn-primary">تحديث نوع الفاتورة</button>
                                            </div>
                                        </div>
                                    </form>

                                    <table class="table table-bordered">
                                        <tr>
                                            <th>معرف الفاتورة (UUID)</th>
                                            <td>{{ $invoice->zatca_uuid ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة الإبلاغ</th>
                                            <td>
                                                @if ($invoice->zatca_reporting_status)
                                                    @switch($invoice->zatca_reporting_status)
                                                        @case('reported')
                                                            <span class="badge badge-success">تم الإبلاغ</span>
                                                            @break
                                                        @case('pending')
                                                            <span class="badge badge-warning">قيد الانتظار</span>
                                                            @break
                                                        @case('failed')
                                                            <span class="badge badge-danger">فشل</span>
                                                            @break
                                                        @default
                                                            <span class="badge badge-secondary">غير محدد</span>
                                                    @endswitch
                                                @else
                                                    <span class="badge badge-secondary">غير مبلغ</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإبلاغ</th>
                                            <td>{{ $invoice->zatca_reported_at ? $invoice->zatca_reported_at->format('Y-m-d H:i') : 'غير مبلغ' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة المطابقة</th>
                                            <td>{{ $invoice->zatca_compliance_status ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة التخليص</th>
                                            <td>{{ $invoice->zatca_clearance_status ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white">
                                    رمز الاستجابة السريعة (QR Code)
                                </div>
                                <div class="card-body text-center">
                                    @if ($invoice->zatca_qr_code)
                                        <div class="mb-3">
                                            <img src="data:image/png;base64,{{ $invoice->zatca_qr_code }}" alt="QR Code" class="img-fluid" style="max-width: 200px;">
                                        </div>
                                    @else
                                        <div class="alert alert-warning">
                                            لم يتم إنشاء رمز الاستجابة السريعة بعد
                                        </div>
                                    @endif
                                    
                                    <a href="{{ route('zatca.generate-qr', $invoice->id) }}" class="btn btn-success">
                                        <i class="fa fa-qrcode"></i> إنشاء/تحديث رمز الاستجابة السريعة
                                    </a>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-warning text-dark">
                                    ملف XML
                                </div>
                                <div class="card-body">
                                    @if ($invoice->zatca_xml_path)
                                        <div class="alert alert-success">
                                            تم إنشاء ملف XML بنجاح
                                            <br>
                                            المسار: {{ $invoice->zatca_xml_path }}
                                        </div>
                                        <a href="{{ asset('storage/' . $invoice->zatca_xml_path) }}" class="btn btn-info" target="_blank">
                                            <i class="fa fa-download"></i> تنزيل ملف XML
                                        </a>
                                    @else
                                        <div class="alert alert-warning">
                                            لم يتم إنشاء ملف XML بعد
                                        </div>
                                    @endif
                                    
                                    <a href="{{ route('zatca.generate-xml', $invoice->id) }}" class="btn btn-warning text-dark mt-2">
                                        <i class="fa fa-file-code"></i> إنشاء/تحديث ملف XML
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-danger text-white">
                                    إجراءات الفوترة الإلكترونية
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <a href="{{ route('zatca.report', $invoice->id) }}" class="btn btn-danger btn-block mb-3">
                                                <i class="fa fa-paper-plane"></i> إرسال الفاتورة إلى هيئة الزكاة والدخل
                                            </a>
                                        </div>
                                        <div class="col-md-6">
                                            <a href="{{ route('zatca.check-status', $invoice->id) }}" class="btn btn-secondary btn-block">
                                                <i class="fa fa-sync"></i> التحقق من حالة الفاتورة
                                            </a>
                                        </div>
                                    </div>

                                    @if (session('status'))
                                        <div class="alert alert-info mt-3">
                                            <h5>حالة الفاتورة لدى هيئة الزكاة والدخل:</h5>
                                            <ul>
                                                @foreach (session('status') as $key => $value)
                                                    <li><strong>{{ $key }}:</strong> {{ $value }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection