@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">إدارة الفوترة الإلكترونية (هيئة الزكاة والدخل)</h4>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead class="thead-dark">
                                <tr>
                                    <th>رقم الفاتورة</th>
                                    <th>العميل</th>
                                    <th>التاريخ</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>نوع الفاتورة</th>
                                    <th>حالة الإبلاغ</th>
                                    <th>تاريخ الإبلاغ</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($invoices as $invoice)
                                    <tr>
                                        <td>{{ $invoice->invoice_number }}</td>
                                        <td>{{ $invoice->customer->name ?? 'غير محدد' }}</td>
                                        <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                        <td>
                                            @if ($invoice->zatca_invoice_type)
                                                @switch($invoice->zatca_invoice_type)
                                                    @case('standard')
                                                        <span class="badge badge-primary">قياسية</span>
                                                        @break
                                                    @case('simplified')
                                                        <span class="badge badge-info">مبسطة</span>
                                                        @break
                                                    @case('debit_note')
                                                        <span class="badge badge-warning">إشعار مدين</span>
                                                        @break
                                                    @case('credit_note')
                                                        <span class="badge badge-danger">إشعار دائن</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">غير محدد</span>
                                                @endswitch
                                            @else
                                                <span class="badge badge-secondary">غير محدد</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($invoice->zatca_reporting_status)
                                                @switch($invoice->zatca_reporting_status)
                                                    @case('reported')
                                                        <span class="badge badge-success">تم الإبلاغ</span>
                                                        @break
                                                    @case('pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                        @break
                                                    @case('failed')
                                                        <span class="badge badge-danger">فشل</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">غير محدد</span>
                                                @endswitch
                                            @else
                                                <span class="badge badge-secondary">غير مبلغ</span>
                                            @endif
                                        </td>
                                        <td>{{ $invoice->zatca_reported_at ? $invoice->zatca_reported_at->format('Y-m-d H:i') : 'غير مبلغ' }}</td>
                                        <td>
                                            <a href="{{ route('zatca.show', $invoice->id) }}" class="btn btn-sm btn-info">
                                                <i class="fa fa-eye"></i> عرض
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد فواتير متوافقة مع متطلبات الفوترة الإلكترونية</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $invoices->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection