@extends('layouts.app')

@section('title', 'تفاصيل أمر الشغل')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل أمر الشغل #{{ $workOrder->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('work-orders.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @can('work_orders.edit')
                        <a href="{{ route('work-orders.edit', $workOrder->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات أمر الشغل</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم أمر الشغل</th>
                                            <td>{{ $workOrder->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة أمر الشغل</th>
                                            <td>
                                                <span class="badge 
                                                    @if($workOrder->status == 'open') badge-success
                                                    @elseif($workOrder->status == 'paused') badge-warning
                                                    @elseif($workOrder->status == 'completed') badge-info
                                                    @elseif($workOrder->status == 'archived') badge-secondary
                                                    @endif">
                                                    {{ $workOrder->status_text }}
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>جاهز فنياً</th>
                                            <td>
                                                @if($workOrder->is_technically_ready)
                                                    <span class="badge badge-success">جاهز</span>
                                                @else
                                                    <span class="badge badge-danger">غير جاهز</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ أمر الشغل</th>
                                            <td>{{ $workOrder->order_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ استلام الفني</th>
                                            <td>{{ $workOrder->received_date ? $workOrder->received_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ انتهاء أمر الشغل</th>
                                            <td>{{ $workOrder->completion_date ? $workOrder->completion_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفني المسؤول</th>
                                            <td>{{ $workOrder->technician ? $workOrder->technician->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>مرحلة المصعد</th>
                                            <td>{{ $workOrder->elevatorStage ? $workOrder->elevatorStage->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $workOrder->creator->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $workOrder->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات المصعد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">موديل المصعد</th>
                                            <td>{{ $workOrder->elevator->model }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم التسلسلي</th>
                                            <td>{{ $workOrder->elevator->serial_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>{{ $workOrder->elevator->customer->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الموقع</th>
                                            <td>
                                                {{ $workOrder->elevator->location->name }}
                                                <a href="{{ route('locations.show', $workOrder->elevator->location->id) }}" class="btn btn-info btn-sm float-left" target="_blank">
                                                    <i class="fas fa-map-marker-alt"></i>
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $workOrder->elevator->location->address }}</td>
                                        </tr>
                                        <tr>
                                            <th>قيمة التعاقد</th>
                                            <td>
                                                @if($workOrder->elevator->installationProject)
                                                    {{ number_format($workOrder->elevator->installationProject->contract_value, 2) }}
                                                @else
                                                    غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($workOrder->notes)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    {{ $workOrder->notes }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection