@extends('layouts.app')

@section('title', 'أوامر الشغل')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">أوامر الشغل</h3>
                    <div class="card-tools">
                        @can('work_orders.view')
                        <a href="{{ route('work-orders.export', request()->all()) }}" class="btn btn-success btn-sm">
                            <i class="fas fa-file-excel"></i> تصدير إلى إكسيل
                        </a>
                        @endcan
                        @can('work_orders.create')
                        <a href="{{ route('work-orders.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة أمر شغل جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- Filter Form -->
                    <div class="card card-outline card-primary mb-4">
                        <div class="card-body">
                            <form action="{{ route('work-orders.index') }}" method="GET">
                                <div class="row">
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="elevator_number">رقم المصعد</label>
                                            <input type="text" name="elevator_number" id="elevator_number" class="form-control" value="{{ request('elevator_number') }}" placeholder="رقم المصعد">
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="customer_name">اسم العميل</label>
                                            <input type="text" name="customer_name" id="customer_name" class="form-control" value="{{ request('customer_name') }}" placeholder="اسم العميل">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="stage_name">اسم المرحلة</label>
                                            <select name="stage_name" id="stage_name" class="form-control">
                                                <option value="">اختر المرحلة</option>
                                                @foreach($elevatorStages as $stage)
                                                    <option value="{{ $stage->id }}" {{ request('stage_name') == $stage->id ? 'selected' : '' }}>{{ $stage->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <label for="status">الحالة</label>
                                            <select name="status" id="status" class="form-control">
                                                <option value="">كل الحالات</option>
                                                <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>مفتوح</option>
                                                <option value="paused" {{ request('status') == 'paused' ? 'selected' : '' }}>متوقف</option>
                                                <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                                <option value="archived" {{ request('status') == 'archived' ? 'selected' : '' }}>مؤرشف</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-search"></i> بحث
                                                </button>
                                                <a href="{{ route('work-orders.index') }}" class="btn btn-secondary">
                                                    <i class="fas fa-undo"></i> إعادة تعيين
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المصعد</th>
                                    <th>العميل</th>
                                    <th>مرحلة المصعد</th>
                                    <th>جاهز فنياً</th>
                                    <th>الفني المسؤول</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الأمر</th>
                                    <th>تاريخ الاستلام</th>
                                    <th>تاريخ الإنجاز</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($workOrders as $workOrder)
                                    <tr>
                                        <td>{{ $workOrder->id }}</td>
                                        <td>{{ $workOrder->elevator->model }} - {{ $workOrder->elevator->serial_number }}</td>
                                        <td>{{ $workOrder->elevator->customer->name }}</td>
                                        <td>{{ $workOrder->elevatorStage ? $workOrder->elevatorStage->name : '-' }}</td>
                                        <td>
                                            @if($workOrder->is_technically_ready)
                                                <span class="badge badge-success">جاهز</span>
                                            @else
                                                <span class="badge badge-danger">غير جاهز</span>
                                            @endif
                                        </td>
                                        <td>{{ $workOrder->technician ? $workOrder->technician->name : '-' }}</td>
                                        <td>
                                            <span class="badge 
                                                @if($workOrder->status == 'open') badge-success
                                                @elseif($workOrder->status == 'paused') badge-warning
                                                @elseif($workOrder->status == 'completed') badge-info
                                                @elseif($workOrder->status == 'archived') badge-secondary
                                                @endif">
                                                {{ $workOrder->status_text }}
                                            </span>
                                        </td>
                                        <td>{{ $workOrder->order_date->format('Y-m-d') }}</td>
                                        <td>{{ $workOrder->received_date ? $workOrder->received_date->format('Y-m-d') : '-' }}</td>
                                        <td>{{ $workOrder->completion_date ? $workOrder->completion_date->format('Y-m-d') : '-' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                @can('work_orders.view')
                                                <a href="{{ route('work-orders.show', $workOrder->id) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('work_orders.edit')
                                                <a href="{{ route('work-orders.edit', $workOrder->id) }}" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                @endcan
                                                
                                                @can('work_orders.delete')
                                                <form action="{{ route('work-orders.destroy', $workOrder->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا الأمر؟')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد أوامر شغل</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $workOrders->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection