@extends('layouts.app')

@section('title', 'تعديل أمر الشغل')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل أمر الشغل #{{ $workOrder->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('work-orders.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('work-orders.update', $workOrder->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_display">المصعد</label>
                                    <input type="text" id="elevator_display" class="form-control" readonly 
                                        value="{{ $workOrder->elevator->model }} - {{ $workOrder->elevator->customer->name ?? 'بدون عميل' }} - {{ $workOrder->elevator->serial_number }}">
                                    <input type="hidden" name="elevator_id" id="elevator_id" value="{{ $workOrder->elevator_id }}">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_name">العميل</label>
                                    <input type="text" id="customer_name" class="form-control" readonly value="{{ $workOrder->elevator->customer->name }}">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="location_info">موقع المصعد</label>
                                    <div class="input-group">
                                        <input type="text" id="location_info" class="form-control" readonly value="{{ $workOrder->elevator->location->name ?? 'غير محدد' }} {{ $workOrder->elevator->location->address ? '- ' . $workOrder->elevator->location->address : '' }}">
                                        <div class="input-group-append">
                                            <button type="button" id="view_location" class="btn btn-info" {{ $workOrder->elevator->location_id ? '' : 'disabled' }}>
                                                <i class="fas fa-map-marker-alt"></i> عرض الموقع
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contract_value">قيمة التعاقد</label>
                                    <input type="text" id="contract_value" class="form-control" readonly 
                                        value="{{ $workOrder->elevator->price && $workOrder->elevator->price > 0 ? $workOrder->elevator->price : ($workOrder->elevator->installationProject ? $workOrder->elevator->installationProject->contract_value : 0) }}">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_paid">إجمالي المبالغ المدفوعة</label>
                                    <input type="text" id="total_paid" class="form-control" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_stage_display">مرحلة المصعد</label>
                                    <input type="text" id="elevator_stage_display" class="form-control" readonly 
                                        value="{{ $workOrder->elevatorStage ? $workOrder->elevatorStage->name : 'غير محدد' }}">
                                    <input type="hidden" name="elevator_stage_id" id="elevator_stage_id" value="{{ $workOrder->elevator_stage_id }}">
                                    @if(!$workOrder->elevator_stage_id)
                                        <small class="text-danger">لم يتم تحديد مرحلة للمصعد في أمر الشغل هذا.</small>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_technically_ready">جاهز فنياً <span class="text-danger">*</span></label>
                                    <select name="is_technically_ready" id="is_technically_ready" class="form-control" required>
                                        <option value="1" {{ old('is_technically_ready', $workOrder->is_technically_ready) == '1' ? 'selected' : '' }}>جاهز</option>
                                        <option value="0" {{ old('is_technically_ready', $workOrder->is_technically_ready) == '0' ? 'selected' : '' }}>غير جاهز</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">حالة أمر الشغل <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="open" {{ old('status', $workOrder->status) == 'open' ? 'selected' : '' }}>مفتوح</option>
                                        <option value="paused" {{ old('status', $workOrder->status) == 'paused' ? 'selected' : '' }}>متوقف</option>
                                        <option value="completed" {{ old('status', $workOrder->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="archived" {{ old('status', $workOrder->status) == 'archived' ? 'selected' : '' }}>مؤرشف</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="order_date_display">تاريخ أمر الشغل</label>
                                    <input type="text" id="order_date_display" class="form-control" readonly 
                                        value="{{ $workOrder->order_date->format('Y-m-d') }}">
                                    <input type="hidden" name="order_date" id="order_date" value="{{ $workOrder->order_date->format('Y-m-d') }}">
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="received_date">تاريخ استلام الفني</label>
                                    <input type="date" name="received_date" id="received_date" class="form-control" 
                                        value="{{ old('received_date', $workOrder->received_date ? $workOrder->received_date->format('Y-m-d') : '') }}">
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="completion_date">تاريخ انتهاء أمر الشغل</label>
                                    <input type="date" name="completion_date" id="completion_date" class="form-control" 
                                        value="{{ old('completion_date', $workOrder->completion_date ? $workOrder->completion_date->format('Y-m-d') : '') }}">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="technician_id">الفني المسؤول</label>
                                    <select name="technician_id" id="technician_id" class="form-control select2">
                                        <option value="">-- اختر الفني --</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ old('technician_id', $workOrder->technician_id) == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="text-muted">يمكن تعيين الفني المسؤول لاحقاً</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control" rows="3">{{ old('notes', $workOrder->notes) }}</textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('work-orders.index') }}" class="btn btn-default">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تهيئة السيلكت2 بشكل أكثر قوة
        function initSelect2() {
            if ($.fn.select2) {
                $('.select2').select2({
                    width: '100%',
                    dir: 'rtl',
                    dropdownAutoWidth: true,
                    theme: 'default'
                });
            }
        }

        // تشغيل التهيئة
        initSelect2();
        
        // إعادة التشغيل بعد قليل للتأكد من تحميل جميع المكتبات
        setTimeout(initSelect2, 500);
        
        // لا نحتاج إلى استدعاء بيانات المصعد عند التغيير لأن الحقل أصبح للقراءة فقط
        // نقوم بتحميل بيانات المصعد مباشرة عند تحميل الصفحة
        var elevatorId = $('#elevator_id').val();
        if (elevatorId) {
            $.ajax({
                url: '/work-orders/elevator-details/' + elevatorId,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (!data.error) {
                        // عرض إجمالي المبالغ المدفوعة فقط، لأن البيانات الأخرى موجودة بالفعل
                        $('#total_paid').val(data.total_paid || 0);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('خطأ AJAX:', error);
                    $('#total_paid').val('غير متاح');
                }
            });
        }
        
        // تهيئة زر عرض الموقع
        @if($workOrder->elevator && $workOrder->elevator->location)
            $('#view_location').data('location-id', {{ $workOrder->elevator->location->id }});
            $('#view_location').prop('disabled', false);
        @else
            $('#view_location').prop('disabled', true);
        @endif
        
        // عرض الموقع في نافذة جديدة
        $('#view_location').on('click', function() {
            var locationId = $(this).data('location-id');
            if (locationId) {
                window.open('/locations/' + locationId, '_blank');
            }
        });
    });
</script>
@endpush