@extends('layouts.app')

@section('title', 'إضافة أمر شغل جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة أمر شغل جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('work-orders.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('work-orders.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد <span class="text-danger">*</span></label>
                                    <select name="elevator_id" id="elevator_id" class="form-control select2" required>
                                        <option value="">-- اختر المصعد --</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->model }} - {{ $elevator->customer->name ?? 'بدون عميل' }} - {{ $elevator->serial_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_name">العميل</label>
                                    <input type="text" id="customer_name" class="form-control" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="location_info">موقع المصعد</label>
                                    <div class="input-group">
                                        <input type="text" id="location_info" class="form-control" readonly>
                                        <div class="input-group-append">
                                            <button type="button" id="view_location" class="btn btn-info" disabled>
                                                <i class="fas fa-map-marker-alt"></i> عرض الموقع
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="contract_value">قيمة التعاقد</label>
                                    <input type="text" id="contract_value" class="form-control" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_paid">إجمالي المبالغ المدفوعة</label>
                                    <input type="text" id="total_paid" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_percentage">نسبة المدفوع من قيمة التعاقد</label>
                                    <div class="input-group">
                                        <input type="text" id="payment_percentage" class="form-control" readonly>
                                        <div class="input-group-append">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_stage_id">مرحلة المصعد <span class="text-danger">*</span></label>
                                    <select name="elevator_stage_id" id="elevator_stage_id" class="form-control select2" required>
                                        <option value="">-- اختر مرحلة المصعد --</option>
                                        @foreach($elevatorStages as $stage)
                                            <option value="{{ $stage->id }}" 
                                                data-percentage="{{ $stage->percentage }}"
                                                {{ old('elevator_stage_id') == $stage->id ? 'selected' : '' }}>
                                                {{ $stage->name }} ({{ $stage->percentage }}%)
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="stage_percentage">النسبة المطلوبة للمرحلة</label>
                                    <div class="input-group">
                                        <input type="text" id="stage_percentage" class="form-control" readonly>
                                        <div class="input-group-append">
                                            <span class="input-group-text">%</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div id="payment_validation_alert" class="alert alert-danger" style="display: none;">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span id="payment_validation_message"></span>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_technically_ready">جاهز فنياً <span class="text-danger">*</span></label>
                                    <select name="is_technically_ready" id="is_technically_ready" class="form-control" required>
                                        <option value="1" {{ old('is_technically_ready', '1') == '1' ? 'selected' : '' }}>جاهز</option>
                                        <option value="0" {{ old('is_technically_ready') == '0' ? 'selected' : '' }}>غير جاهز</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">حالة أمر الشغل <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="open" {{ old('status') == 'open' ? 'selected' : '' }}>مفتوح</option>
                                        <option value="paused" {{ old('status') == 'paused' ? 'selected' : '' }}>متوقف</option>
                                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="archived" {{ old('status') == 'archived' ? 'selected' : '' }}>مؤرشف</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="order_date">تاريخ أمر الشغل <span class="text-danger">*</span></label>
                                    <input type="date" name="order_date" id="order_date" class="form-control" value="{{ old('order_date', date('Y-m-d')) }}" required>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="received_date">تاريخ استلام الفني</label>
                                    <input type="date" name="received_date" id="received_date" class="form-control" value="{{ old('received_date') }}">
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="completion_date">تاريخ انتهاء أمر الشغل</label>
                                    <input type="date" name="completion_date" id="completion_date" class="form-control" value="{{ old('completion_date') }}">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="technician_id">الفني المسؤول</label>
                                    <select name="technician_id" id="technician_id" class="form-control select2">
                                        <option value="">-- اختر الفني --</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ old('technician_id') == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="text-muted">يمكن تعيين الفني المسؤول لاحقاً</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control" rows="3">{{ old('notes') }}</textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ
                                </button>
                                <a href="{{ route('work-orders.index') }}" class="btn btn-default">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تهيئة السيلكت2 بشكل أكثر قوة
        function initSelect2() {
            if ($.fn.select2) {
                $('.select2').select2({
                    width: '100%',
                    dir: 'rtl',
                    dropdownAutoWidth: true,
                    theme: 'default'
                });
            }
        }

        // تشغيل التهيئة
        initSelect2();
        
        // إعادة التشغيل بعد قليل للتأكد من تحميل جميع المكتبات
        setTimeout(initSelect2, 500);
        
        // متغيرات عامة للتحقق من المدفوعات
        var contractValue = 0;
        var totalPaid = 0;
        var paymentPercentage = 0;
        
        // استدعاء بيانات المصعد عند اختياره
        $('#elevator_id').on('change', function() {
            var elevatorId = $(this).val();
            if (elevatorId) {
                // إظهار مؤشر التحميل أو رسالة
                $('#customer_name').val('جاري التحميل...');
                $('#location_info').val('جاري التحميل...');
                $('#contract_value').val('جاري التحميل...');
                $('#total_paid').val('جاري التحميل...');
                $('#payment_percentage').val('جاري التحميل...');
                
                // إخفاء رسالة التحقق من المدفوعات
                $('#payment_validation_alert').hide();
                
                $.ajax({
                    url: '/work-orders/elevator-details/' + elevatorId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data.error) {
                            // إذا كان هناك خطأ في الاستجابة
                            alert(data.error);
                            resetFields();
                            return;
                        }
                        
                        $('#customer_name').val(data.customer);
                        
                        // التحقق من وجود بيانات الموقع
                        if (data.location && data.location.name) {
                            var locationText = data.location.name;
                            if (data.location.address) {
                                locationText += ' - ' + data.location.address;
                            }
                            $('#location_info').val(locationText);
                            
                            // تفعيل زر عرض الموقع إذا كان هناك معرف للموقع
                            if (data.location.id) {
                                $('#view_location').prop('disabled', false);
                                $('#view_location').data('location-id', data.location.id);
                            } else {
                                $('#view_location').prop('disabled', true);
                            }
                        } else {
                            $('#location_info').val('غير محدد');
                            $('#view_location').prop('disabled', true);
                        }
                        
                        // عرض سعر المصعد إذا كان متاحاً، وإلا عرض قيمة التعاقد
                        if (data.elevator_price && data.elevator_price > 0) {
                            contractValue = parseFloat(data.elevator_price);
                            $('#contract_value').val(contractValue.toFixed(2));
                        } else {
                            contractValue = parseFloat(data.contract_value || 0);
                            $('#contract_value').val(contractValue.toFixed(2));
                        }
                        
                        // عرض إجمالي المبالغ المدفوعة
                        totalPaid = parseFloat(data.total_paid || 0);
                        $('#total_paid').val(totalPaid.toFixed(2));
                        
                        // حساب نسبة المدفوع
                        calculatePaymentPercentage();
                        
                        // التحقق من كفاية المدفوعات للمرحلة المختارة
                        validatePaymentForStage();
                    },
                    error: function(xhr, status, error) {
                        console.error('خطأ AJAX:', error);
                        
                        // عرض رسالة خطأ أكثر تفصيلاً إذا كانت متاحة
                        var errorMessage = 'حدث خطأ أثناء استرجاع بيانات المصعد';
                        if (xhr.responseJSON && xhr.responseJSON.error) {
                            errorMessage = xhr.responseJSON.error;
                        }
                        
                        alert(errorMessage);
                        resetFields();
                    }
                });
            } else {
                resetFields();
            }
        });
        
        // حساب نسبة المدفوع من قيمة التعاقد
        function calculatePaymentPercentage() {
            paymentPercentage = 0;
            if (contractValue > 0) {
                paymentPercentage = (totalPaid / contractValue) * 100;
            }
            $('#payment_percentage').val(paymentPercentage.toFixed(2));
            return paymentPercentage;
        }
        
        // التحقق من تغيير مرحلة المصعد
        $('#elevator_stage_id').on('change', function() {
            validatePaymentForStage();
        });
        
        // التحقق من كفاية المدفوعات لمرحلة المصعد المختارة
        function validatePaymentForStage() {
            var selectedStage = $('#elevator_stage_id option:selected');
            if (selectedStage.val()) {
                var stagePercentage = parseFloat(selectedStage.data('percentage') || 0);
                $('#stage_percentage').val(stagePercentage.toFixed(2));
                
                // التحقق من كفاية المدفوعات
                if (paymentPercentage < stagePercentage) {
                    // عرض رسالة تحذير
                    $('#payment_validation_message').text(
                        'تنبيه: مدفوعات العميل غير كافية لمرحلة المصعد المختارة. النسبة المطلوبة: ' + 
                        stagePercentage.toFixed(2) + '% والنسبة المدفوعة: ' + 
                        paymentPercentage.toFixed(2) + '%'
                    );
                    $('#payment_validation_alert').removeClass('alert-danger').addClass('alert-warning').show();
                    
                    // لا نقوم بتعطيل زر الحفظ للسماح للمدير بالمتابعة إذا أراد
                    $('button[type="submit"]').prop('disabled', false);
                } else {
                    // إخفاء رسالة التحذير
                    $('#payment_validation_alert').hide();
                    
                    // تفعيل زر الحفظ
                    $('button[type="submit"]').prop('disabled', false);
                }
            } else {
                $('#stage_percentage').val('');
                $('#payment_validation_alert').hide();
                $('button[type="submit"]').prop('disabled', false);
            }
        }
        
        // دالة لإعادة تعيين الحقول
        function resetFields() {
            $('#customer_name').val('');
            $('#location_info').val('');
            $('#contract_value').val('');
            $('#total_paid').val('');
            $('#payment_percentage').val('');
            $('#stage_percentage').val('');
            $('#view_location').prop('disabled', true);
            $('#payment_validation_alert').hide();
            
            // إعادة تعيين المتغيرات العامة
            contractValue = 0;
            totalPaid = 0;
            paymentPercentage = 0;
            
            // تفعيل زر الحفظ
            $('button[type="submit"]').prop('disabled', false);
        }
        
        // عرض الموقع في نافذة جديدة
        $('#view_location').on('click', function() {
            var locationId = $(this).data('location-id');
            if (locationId) {
                window.open('/locations/' + locationId, '_blank');
            }
        });
        
        // التحقق من صحة النموذج قبل الإرسال
        $('form').on('submit', function(e) {
            var selectedStage = $('#elevator_stage_id option:selected');
            if (selectedStage.val()) {
                var stagePercentage = parseFloat(selectedStage.data('percentage') || 0);
                
                // التحقق من كفاية المدفوعات
                if (paymentPercentage < stagePercentage) {
                    if (!confirm('مدفوعات العميل غير كافية لمرحلة المصعد المختارة. هل تريد الاستمرار في حفظ أمر الشغل؟')) {
                        e.preventDefault();
                        return false;
                    }
                }
            } else {
                e.preventDefault();
                alert('يجب اختيار مرحلة المصعد.');
                return false;
            }
            return true;
        });
    });
</script>
@endpush