@extends('layouts.modern')

@section('title', $user->name)

@section('header', $user->name)

@section('content')
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">معلومات المستخدم</h6>
                @if(auth()->user()->id == $user->id || auth()->user()->can('edit users'))
                <a href="{{ route('users.edit', $user->id) }}" class="btn btn-primary btn-sm">
                    <i class="bi bi-pencil"></i> تعديل
                </a>
                @endif
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    <div class="img-profile rounded-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 100px; height: 100px; font-size: 2.5rem;">
                        {{ strtoupper(substr($user->name, 0, 1)) }}
                    </div>
                    <h5>{{ $user->name }}</h5>
                    <p class="text-muted">
                        @foreach($user->roles as $role)
                            <span class="badge bg-info">{{ ucfirst($role->name) }}</span>
                        @endforeach
                        @if($user->is_active)
                            <span class="badge bg-success">نشط</span>
                        @else
                            <span class="badge bg-danger">غير نشط</span>
                        @endif
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">معلومات الاتصال</h6>
                    <p class="mb-1"><i class="bi bi-envelope me-2"></i> {{ $user->email }}</p>
                    <p class="mb-1"><i class="bi bi-telephone me-2"></i> {{ $user->phone ?: 'غير متوفر' }}</p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">الشركة والفرع</h6>
                    <p class="mb-1"><strong>الشركة:</strong> 
                        @if($user->company)
                            <a href="{{ route('companies.show', $user->company_id) }}">{{ $user->company->name }}</a>
                        @else
                            <span class="text-muted">غير محدد</span>
                        @endif
                    </p>
                    <p class="mb-1"><strong>الفرع:</strong> 
                        @if($user->branch)
                            <a href="{{ route('branches.show', $user->branch_id) }}">{{ $user->branch->name }}</a>
                        @else
                            <span class="text-muted">غير مرتبط بفرع</span>
                        @endif
                    </p>
                    <p class="mb-1"><strong>المسمى الوظيفي:</strong> {{ $user->job_title ?: 'غير محدد' }}</p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">معلومات الحساب</h6>
                    <p class="mb-1"><strong>تاريخ الإنشاء:</strong> {{ $user->created_at->format('Y-m-d') }}</p>
                    <p class="mb-1"><strong>آخر تسجيل دخول:</strong> {{ $statistics['last_login'] ? $statistics['last_login']->format('Y-m-d H:i') : 'لم يسجل الدخول بعد' }}</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-8 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">نشاط المستخدم</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            العملاء</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['customers_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person-badge fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            المصاعد</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['elevators_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-arrow-up-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            العقود</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['contracts_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-file-earmark-text fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            الفواتير</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['invoices_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-receipt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('customers.index', ['user_id' => $user->id]) }}" class="btn btn-success">
                                <i class="bi bi-person-badge"></i> عرض العملاء
                            </a>
                            <a href="{{ route('elevators.index', ['user_id' => $user->id]) }}" class="btn btn-info">
                                <i class="bi bi-arrow-up-square"></i> عرض المصاعد
                            </a>
                            <a href="{{ route('maintenance-contracts.index', ['user_id' => $user->id]) }}" class="btn btn-warning">
                                <i class="bi bi-file-earmark-text"></i> عرض العقود
                            </a>
                            <a href="{{ route('invoices.index', ['user_id' => $user->id]) }}" class="btn btn-danger">
                                <i class="bi bi-receipt"></i> عرض الفواتير
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        @if(auth()->user()->hasAnyRole(['admin', 'super_admin']))
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">صلاحيات المستخدم</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($user->getAllPermissions()->chunk(4) as $permissionChunk)
                        @foreach($permissionChunk as $permission)
                            <div class="col-md-3 mb-2">
                                <span class="badge bg-secondary">{{ $permission->name }}</span>
                            </div>
                        @endforeach
                    @endforeach
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection