@extends('layouts.app')

@section('title', 'تفاصيل المستخدم')

@section('styles')
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/arabic-theme.css') }}">
    <style>
        .user-profile-header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .user-avatar {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            background-color: #1e88e5;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 40px;
            font-weight: bold;
            margin-left: 25px;
        }
        
        .user-info {
            flex: 1;
        }
        
        .user-name {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 5px;
            color: #1565C0;
        }
        
        .user-email {
            color: #757575;
            font-size: 16px;
            margin-bottom: 10px;
        }
        
        .user-status {
            display: inline-block;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 500;
        }
        
        .status-active {
            background-color: #4CAF50;
            color: white;
        }
        
        .status-inactive {
            background-color: #F44336;
            color: white;
        }
        
        .info-section {
            background-color: #fff;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .info-section-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #1e88e5;
            color: #1565C0;
        }
        
        .info-item {
            margin-bottom: 15px;
            display: flex;
        }
        
        .info-label {
            font-weight: 600;
            min-width: 150px;
            color: #455A64;
        }
        
        .info-value {
            flex: 1;
        }
        
        .role-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }
        
        .role-tag {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 4px;
            font-size: 13px;
            font-weight: 500;
            color: white;
        }
        
        .role-tag.admin { background-color: #1565C0; }
        .role-tag.manager { background-color: #00897B; }
        .role-tag.accountant { background-color: #7B1FA2; }
        .role-tag.sales { background-color: #EF6C00; }
        .role-tag.hr { background-color: #D81B60; }
        .role-tag.maintenance { background-color: #0097A7; }
        .role-tag.warehouse { background-color: #388E3C; }
        .role-tag.user { background-color: #5D4037; }
        
        .action-buttons {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }
        
        .action-buttons .btn {
            padding: 8px 20px;
        }
        
        .created-at {
            color: #757575;
            font-size: 14px;
            margin-top: 5px;
        }
    </style>
@endsection

@section('content')
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h1 class="mb-0">تفاصيل المستخدم</h1>
                        <div>
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-right ml-1"></i>
                                العودة للقائمة
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="user-profile-header">
                        <div class="user-avatar">
                            {{ substr($user->name, 0, 1) }}
                        </div>
                        <div class="user-info">
                            <div class="user-name">{{ $user->name }}</div>
                            <div class="user-email">{{ $user->email }}</div>
                            <div>
                                @if($user->is_active)
                                    <span class="user-status status-active">نشط</span>
                                @else
                                    <span class="user-status status-inactive">غير نشط</span>
                                @endif
                            </div>
                            <div class="created-at">
                                تاريخ الإنشاء: {{ $user->created_at->format('Y-m-d H:i') }}
                            </div>
                        </div>
                    </div>
                    
                    <div class="info-section">
                        <h3 class="info-section-title">المعلومات الأساسية</h3>
                        
                        <div class="info-item">
                            <div class="info-label">اسم المستخدم:</div>
                            <div class="info-value">{{ $user->name }}</div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">البريد الإلكتروني:</div>
                            <div class="info-value">{{ $user->email }}</div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">الحالة:</div>
                            <div class="info-value">
                                @if($user->is_active)
                                    <span class="user-status status-active">نشط</span>
                                @else
                                    <span class="user-status status-inactive">غير نشط</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <div class="info-section">
                        <h3 class="info-section-title">معلومات الشركة والفرع</h3>
                        
                        <div class="info-item">
                            <div class="info-label">الشركة:</div>
                            <div class="info-value">{{ $user->company->name ?? 'غير محدد' }}</div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">الفرع:</div>
                            <div class="info-value">{{ $user->branch->name ?? 'غير محدد' }}</div>
                        </div>
                    </div>
                    
                    <div class="info-section">
                        <h3 class="info-section-title">الأدوار والصلاحيات</h3>
                        
                        <div class="info-item">
                            <div class="info-label">الأدوار:</div>
                            <div class="info-value">
                                <div class="role-tags">
                                    @forelse($user->roles as $role)
                                        <span class="role-tag {{ strtolower(str_replace(' ', '-', $role->name)) }}">{{ $role->name }}</span>
                                    @empty
                                        <span>لا توجد أدوار محددة</span>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="action-buttons">
                        <a href="{{ route('users.edit', $user->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit ml-1"></i>
                            تعديل المستخدم
                        </a>
                        
                        <form action="{{ route('users.destroy', $user->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا المستخدم؟');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash-alt ml-1"></i>
                                حذف المستخدم
                            </button>
                        </form>
                        
                        <form action="{{ route('users.toggle-status', $user->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PATCH')
                            @if($user->is_active)
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-ban ml-1"></i>
                                    تعطيل المستخدم
                                </button>
                            @else
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-check-circle ml-1"></i>
                                    تفعيل المستخدم
                                </button>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection