@extends('layouts.modern')

@section('title', 'إدارة المستخدمين')

@section('header', 'المستخدمين')

@section('styles')
<link rel="stylesheet" href="{{ asset('css/arabic-theme.css') }}">
<style>
    /* تحسينات إضافية خاصة بصفحة المستخدمين */
    .card {
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        transition: all 0.3s ease;
    }
    
    .card:hover {
        box-shadow: 0 8px 25px rgba(0,0,0,0.12);
        transform: translateY(-5px);
    }
    
    .card-header {
        background: linear-gradient(45deg, #1e88e5, #1565c0);
        padding: 15px 20px;
        border-bottom: none;
    }
    
    .card-header h6 {
        font-size: 18px;
        font-weight: 700;
        margin: 0;
    }
    
    .add-user-btn {
        background: linear-gradient(45deg, #26a69a, #00897b);
        border: none;
        box-shadow: 0 4px 10px rgba(38, 166, 154, 0.3);
        padding: 8px 16px;
        border-radius: 50px;
        font-weight: 600;
        transition: all 0.3s;
    }
    
    .add-user-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 15px rgba(38, 166, 154, 0.4);
    }
    
    .filter-container {
        background-color: #f8f9fa;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 25px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }
    
    .form-label {
        color: #1565c0;
        font-weight: 600;
        margin-bottom: 8px;
    }
    
    .form-select, .form-control {
        border-radius: 8px;
        border: 1px solid #e0e0e0;
        padding: 10px 15px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.02);
        transition: all 0.3s;
    }
    
    .form-select:focus, .form-control:focus {
        border-color: #1e88e5;
        box-shadow: 0 0 0 0.25rem rgba(30, 136, 229, 0.25);
    }
    
    .table {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .table thead th {
        background-color: #1e88e5;
        color: white;
        font-weight: 600;
        padding: 15px;
        border-bottom: none;
        position: relative;
    }
    
    .table thead th:after {
        content: '';
        position: absolute;
        bottom: 0;
        right: 0;
        width: 100%;
        height: 3px;
        background: linear-gradient(to left, #1e88e5, transparent);
    }
    
    .table tbody tr {
        transition: all 0.2s;
    }
    
    .table tbody tr:hover {
        background-color: rgba(30, 136, 229, 0.05);
    }
    
    .table tbody td {
        padding: 15px;
        vertical-align: middle;
    }
    
    .role-pill {
        display: inline-block;
        padding: 5px 12px;
        margin: 3px;
        border-radius: 50px;
        font-size: 12px;
        font-weight: 600;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .role-admin { background-color: #1565C0; color: white; }
    .role-manager { background-color: #00897B; color: white; }
    .role-accountant { background-color: #7B1FA2; color: white; }
    .role-technician { background-color: #EF6C00; color: white; }
    .role-maintenance { background-color: #0097A7; color: white; }
    .role-company { background-color: #D81B60; color: white; }
    .role-hr { background-color: #388E3C; color: white; }
    .role-warehouse { background-color: #5D4037; color: white; }
    .role-user { background-color: #546E7A; color: white; }
    
    .status-badge {
        padding: 6px 14px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 12px;
        display: inline-block;
        min-width: 80px;
        text-align: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    
    .status-active {
        background-color: #4CAF50;
        color: white;
    }
    
    .status-inactive {
        background-color: #F44336;
        color: white;
    }
    
    .action-btn {
        width: 36px;
        height: 36px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        margin: 0 3px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        transition: all 0.2s;
    }
    
    .action-btn:hover {
        transform: scale(1.1);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }
    
    .action-btn-view {
        background-color: #4CAF50;
        color: white;
    }
    
    .action-btn-edit {
        background-color: #2196F3;
        color: white;
    }
    
    .action-btn-delete {
        background-color: #F44336;
        color: white;
    }
    
    .pagination {
        margin-top: 25px;
    }
    
    .pagination .page-item .page-link {
        border-radius: 50px;
        margin: 0 3px;
        min-width: 40px;
        text-align: center;
        color: #1e88e5;
        border: 1px solid #e0e0e0;
        transition: all 0.2s;
    }
    
    .pagination .page-item.active .page-link {
        background-color: #1e88e5;
        border-color: #1e88e5;
        color: white;
        box-shadow: 0 2px 5px rgba(30, 136, 229, 0.3);
    }
    
    .pagination .page-item .page-link:hover {
        background-color: #f5f5f5;
        border-color: #1e88e5;
    }
    
    .pagination .page-item.active .page-link:hover {
        background-color: #1565c0;
    }
    
    .empty-state {
        text-align: center;
        padding: 50px 20px;
        background-color: #f8f9fa;
        border-radius: 10px;
        margin: 20px 0;
    }
    
    .empty-state i {
        font-size: 60px;
        color: #1e88e5;
        margin-bottom: 20px;
        opacity: 0.7;
    }
    
    .empty-state h4 {
        color: #1565c0;
        font-weight: 700;
        margin-bottom: 10px;
    }
    
    .empty-state p {
        color: #757575;
        margin-bottom: 20px;
        font-size: 16px;
    }
    
    .email-cell {
        direction: ltr;
        text-align: right;
        font-family: 'Courier New', monospace;
        font-weight: 500;
    }
    
    .user-name {
        font-weight: 700;
        color: #1565c0;
    }
    
    .branch-name {
        font-weight: 600;
        color: #546e7a;
    }
</style>
@endsection

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-white">جميع المستخدمين</h6>
        @if(auth()->user()->hasPermissionTo('create_user') || auth()->user()->hasPermissionTo('create_users'))
        <a href="{{ route('users.arabic.create') }}" class="btn btn-sm add-user-btn">
            <i class="fas fa-plus-circle ml-1"></i> إضافة مستخدم جديد
        </a>
        @endif
    </div>
    <div class="card-body">
        <div class="filter-container mb-4">
            <form action="{{ route('users.arabic.index') }}" method="GET" class="row g-3">
                <div class="col-md-4">
                    <label for="branch_id" class="form-label">تصفية حسب الفرع</label>
                    <select class="form-select shadow-sm" id="branch_id" name="branch_id">
                        <option value="">جميع الفروع</option>
                        @foreach($branches as $branch)
                            <option value="{{ $branch->id }}" {{ request('branch_id') == $branch->id ? 'selected' : '' }}>
                                {{ $branch->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="role" class="form-label">تصفية حسب الدور</label>
                    <select class="form-select shadow-sm" id="role" name="role">
                        <option value="">جميع الأدوار</option>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}" {{ request('role') == $role->name ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">
                        <i class="fas fa-filter ml-1"></i> تصفية
                    </button>
                    <a href="{{ route('users.arabic.index') }}" class="btn btn-secondary">
                        <i class="fas fa-redo ml-1"></i> إعادة ضبط
                    </a>
                </div>
            </form>
        </div>
        
        @if($users->count() > 0)
        <div class="table-responsive">
            <table class="table" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>الاسم</th>
                        <th>البريد الإلكتروني</th>
                        <th>الفرع</th>
                        <th>الدور</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr>
                        <td class="user-name">{{ $user->name }}</td>
                        <td class="email-cell">{{ $user->email }}</td>
                        <td class="branch-name">{{ $user->branch ? $user->branch->name : 'غير محدد' }}</td>
                        <td>
                            <div class="roles-container">
                                @foreach($user->roles as $role)
                                    @php
                                        $roleClass = 'role-user';
                                        if (strpos(strtolower($role->name), 'admin') !== false) $roleClass = 'role-admin';
                                        elseif (strpos(strtolower($role->name), 'manager') !== false) $roleClass = 'role-manager';
                                        elseif (strpos(strtolower($role->name), 'accountant') !== false) $roleClass = 'role-accountant';
                                        elseif (strpos(strtolower($role->name), 'technician') !== false) $roleClass = 'role-technician';
                                        elseif (strpos(strtolower($role->name), 'maintenance') !== false) $roleClass = 'role-maintenance';
                                        elseif (strpos(strtolower($role->name), 'company') !== false) $roleClass = 'role-company';
                                        elseif (strpos(strtolower($role->name), 'hr') !== false) $roleClass = 'role-hr';
                                        elseif (strpos(strtolower($role->name), 'warehouse') !== false) $roleClass = 'role-warehouse';
                                    @endphp
                                    <span class="role-pill {{ $roleClass }}">
                                        {{ $role->name }}
                                    </span>
                                @endforeach
                            </div>
                        </td>
                        <td>
                            @if($user->is_active)
                                <span class="status-badge status-active">نشط</span>
                            @else
                                <span class="status-badge status-inactive">غير نشط</span>
                            @endif
                        </td>
                        <td>
                            <div class="action-buttons">
                                <a href="{{ route('users.arabic.show', $user->id) }}" class="btn action-btn action-btn-view" title="عرض">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @if(auth()->user()->id == $user->id || auth()->user()->can('edit users'))
                                <a href="{{ route('users.arabic.edit', $user->id) }}" class="btn action-btn action-btn-edit" title="تعديل">
                                    <i class="fas fa-edit"></i>
                                </a>
                                @endif
                                @if(auth()->user()->id != $user->id && auth()->user()->can('delete users'))
                                <form action="{{ route('users.arabic.destroy', $user->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn action-btn action-btn-delete" title="حذف" 
                                            onclick="return confirm('هل أنت متأكد من رغبتك في حذف هذا المستخدم؟')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-center mt-4">
            {{ $users->appends(request()->query())->links() }}
        </div>
        @else
        <div class="empty-state">
            <i class="fas fa-users"></i>
            <h4>لا يوجد مستخدمين</h4>
            <p>لم يتم العثور على مستخدمين مطابقين لمعايير البحث.</p>
            @can('create users')
            <a href="{{ route('users.arabic.create') }}" class="btn btn-primary add-user-btn">
                <i class="fas fa-plus-circle ml-1"></i> إضافة مستخدم جديد
            </a>
            @endcan
        </div>
        @endif
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تحسين تجربة المستخدم عند التفاعل مع الجدول
        const tableRows = document.querySelectorAll('tbody tr');
        tableRows.forEach(row => {
            row.addEventListener('mouseover', function() {
                this.style.backgroundColor = 'rgba(30, 136, 229, 0.05)';
            });
            row.addEventListener('mouseout', function() {
                this.style.backgroundColor = '';
            });
        });
        
        // تحسين تجربة المستخدم عند التفاعل مع أزرار الإجراءات
        const actionButtons = document.querySelectorAll('.action-btn');
        actionButtons.forEach(button => {
            button.addEventListener('mouseover', function() {
                this.style.transform = 'scale(1.1)';
            });
            button.addEventListener('mouseout', function() {
                this.style.transform = 'scale(1)';
            });
        });
    });
</script>
@endsection