@extends('layouts.app')

@section('title', 'إضافة مستخدم جديد')

@section('styles')
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/arabic-theme.css') }}">
    <style>
        .form-section {
            background-color: #fff;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .form-section-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #1e88e5;
            color: #1565C0;
        }
        
        .required-field::after {
            content: " *";
            color: #F44336;
        }
        
        .role-checkbox-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 10px;
            margin-top: 10px;
        }
        
        .role-checkbox-item {
            display: flex;
            align-items: center;
            padding: 8px 12px;
            background-color: #f5f7fa;
            border-radius: 4px;
            transition: all 0.2s ease;
        }
        
        .role-checkbox-item:hover {
            background-color: #e3f2fd;
        }
        
        .role-checkbox-item input[type="checkbox"] {
            margin-left: 10px;
        }
        
        .form-actions {
            display: flex;
            justify-content: flex-end;
            gap: 10px;
            margin-top: 20px;
        }
        
        .password-toggle {
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #757575;
        }
        
        .password-field-container {
            position: relative;
        }
    </style>
@endsection

@section('content')
<div class="container-fluid py-4">
    <div class="row justify-content-center">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <h1 class="mb-0">إضافة مستخدم جديد</h1>
                </div>
                <div class="card-body">
                    <form action="{{ route('users.store') }}" method="POST">
                        @csrf
                        
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <div class="form-section">
                            <h3 class="form-section-title">المعلومات الأساسية</h3>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name" class="required-field">اسم المستخدم</label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                                        @error('name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="email" class="required-field">البريد الإلكتروني</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email') }}" required>
                                        @error('email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group password-field-container">
                                        <label for="password" class="required-field">كلمة المرور</label>
                                        <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password" required>
                                        <span class="password-toggle" id="password-toggle">
                                            <i class="fas fa-eye"></i>
                                        </span>
                                        @error('password')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group password-field-container">
                                        <label for="password_confirmation" class="required-field">تأكيد كلمة المرور</label>
                                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                                        <span class="password-toggle" id="confirm-password-toggle">
                                            <i class="fas fa-eye"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-section">
                            <h3 class="form-section-title">معلومات الشركة والفرع</h3>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="company_id" class="required-field">الشركة</label>
                                        <select class="form-control @error('company_id') is-invalid @enderror" id="company_id" name="company_id" required>
                                            <option value="">اختر الشركة</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                                    {{ $company->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('company_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="branch_id">الفرع</label>
                                        <select class="form-control @error('branch_id') is-invalid @enderror" id="branch_id" name="branch_id">
                                            <option value="">اختر الفرع (اختياري)</option>
                                            @foreach($branches as $branch)
                                                <option value="{{ $branch->id }}" {{ old('branch_id') == $branch->id ? 'selected' : '' }}>
                                                    {{ $branch->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('branch_id')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-section">
                            <h3 class="form-section-title">الأدوار والصلاحيات</h3>
                            
                            <div class="form-group">
                                <label class="required-field">الأدوار</label>
                                <div class="role-checkbox-container">
                                    @foreach($roles as $role)
                                        <div class="role-checkbox-item">
                                            <input type="checkbox" id="role_{{ $role->id }}" name="roles[]" value="{{ $role->id }}" 
                                                {{ (is_array(old('roles')) && in_array($role->id, old('roles'))) ? 'checked' : '' }}>
                                            <label for="role_{{ $role->id }}">{{ $role->name }}</label>
                                        </div>
                                    @endforeach
                                </div>
                                @error('roles')
                                    <div class="text-danger mt-2">{{ $message }}</div>
                                @enderror
                            </div>
                            
                            <div class="form-group mt-4">
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" {{ old('is_active') ? 'checked' : 'checked' }}>
                                    <label class="custom-control-label" for="is_active">المستخدم نشط</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-actions">
                            <a href="{{ route('users.index') }}" class="btn btn-secondary">إلغاء</a>
                            <button type="submit" class="btn btn-primary">حفظ المستخدم</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تبديل عرض كلمة المرور
        $('#password-toggle').click(function() {
            const passwordField = $('#password');
            const passwordFieldType = passwordField.attr('type');
            const icon = $(this).find('i');
            
            if (passwordFieldType === 'password') {
                passwordField.attr('type', 'text');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            } else {
                passwordField.attr('type', 'password');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            }
        });
        
        // تبديل عرض تأكيد كلمة المرور
        $('#confirm-password-toggle').click(function() {
            const confirmPasswordField = $('#password_confirmation');
            const confirmPasswordFieldType = confirmPasswordField.attr('type');
            const icon = $(this).find('i');
            
            if (confirmPasswordFieldType === 'password') {
                confirmPasswordField.attr('type', 'text');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            } else {
                confirmPasswordField.attr('type', 'password');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            }
        });
        
        // تحديث قائمة الفروع عند تغيير الشركة
        $('#company_id').change(function() {
            const companyId = $(this).val();
            
            if (companyId) {
                // هنا يمكن إضافة طلب AJAX لجلب الفروع المرتبطة بالشركة المحددة
                // $.ajax({
                //     url: '/api/branches/' + companyId,
                //     type: 'GET',
                //     success: function(data) {
                //         let options = '<option value="">اختر الفرع (اختياري)</option>';
                //         data.forEach(function(branch) {
                //             options += `<option value="${branch.id}">${branch.name}</option>`;
                //         });
                //         $('#branch_id').html(options);
                //     }
                // });
            } else {
                $('#branch_id').html('<option value="">اختر الفرع (اختياري)</option>');
            }
        });
    });
</script>
@endsection