@extends('layouts.modern')

@section('header', 'اختبار الصلاحيات')

@section('breadcrumb')
<li class="breadcrumb-item active">اختبار الصلاحيات</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-12 col-md-12">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-shield-alt me-2"></i>اختبار الصلاحيات
                    </h5>
                </div>

                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h5 class="card-title">معلومات المستخدم</h5>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <p><strong>الاسم:</strong> {{ Auth::user()->name }}</p>
                                        </div>
                                        <div class="col-md-5">
                                            <p><strong>البريد الإلكتروني:</strong> {{ Auth::user()->email }}</p>
                                        </div>
                                        <div class="col-md-3">
                                            <p><strong>المعرف:</strong> {{ Auth::user()->id }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card h-100">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-user-tag me-2"></i>الأدوار
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        @foreach(Auth::user()->roles as $role)
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                {{ $role->name }}
                                                <span class="badge bg-primary rounded-pill">{{ $role->id }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card h-100">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-key me-2"></i>الصلاحيات
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group">
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            create_maintenance_invoices
                                            <span class="badge {{ Auth::user()->hasPermission('create_maintenance_invoices') ? 'bg-success' : 'bg-danger' }} rounded-pill">
                                                {{ Auth::user()->hasPermission('create_maintenance_invoices') ? 'نعم' : 'لا' }}
                                            </span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            view_maintenance_financial_reports
                                            <span class="badge {{ Auth::user()->hasPermission('view_maintenance_financial_reports') ? 'bg-success' : 'bg-danger' }} rounded-pill">
                                                {{ Auth::user()->hasPermission('view_maintenance_financial_reports') ? 'نعم' : 'لا' }}
                                            </span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            manage_maintenance_invoices
                                            <span class="badge {{ Auth::user()->hasPermission('manage_maintenance_invoices') ? 'bg-success' : 'bg-danger' }} rounded-pill">
                                                {{ Auth::user()->hasPermission('manage_maintenance_invoices') ? 'نعم' : 'لا' }}
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-check-circle me-2"></i>اختبار can
                                    </h5>
                                </div>
                                <div class="card-body">
                                    @can('create_maintenance_invoices')
                                        <div class="alert alert-success">
                                            <i class="fas fa-check-circle me-2"></i>يمكنك إنشاء فواتير الصيانة
                                        </div>
                                    @else
                                        <div class="alert alert-danger">
                                            <i class="fas fa-times-circle me-2"></i>لا يمكنك إنشاء فواتير الصيانة
                                        </div>
                                    @endcan
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="fas fa-check-double me-2"></i>اختبار canany
                                    </h5>
                                </div>
                                <div class="card-body">
                                    @canany(['create_maintenance_invoices', 'manage_maintenance_invoices'])
                                        <div class="alert alert-success">
                                            <i class="fas fa-check-circle me-2"></i>يمكنك إنشاء أو إدارة فواتير الصيانة
                                        </div>
                                    @else
                                        <div class="alert alert-danger">
                                            <i class="fas fa-times-circle me-2"></i>لا يمكنك إنشاء أو إدارة فواتير الصيانة
                                        </div>
                                    @endcanany
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection