@extends('layouts.modern')

@section('title', 'إعدادات الضرائب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إعدادات الضرائب</h3>
                    <div class="card-tools">
                        <a href="{{ route('tax_settings.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة إعداد ضريبة جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>النسبة</th>
                                    <th>الوصف</th>
                                    <th>الحالة</th>
                                    <th>افتراضي</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($taxSettings as $taxSetting)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $taxSetting->name }}</td>
                                    <td>{{ $taxSetting->rate }}%</td>
                                    <td>{{ $taxSetting->description ?: 'لا يوجد وصف' }}</td>
                                    <td>
                                        @if($taxSetting->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($taxSetting->is_default)
                                            <span class="badge badge-primary">افتراضي</span>
                                        @else
                                            <form action="{{ route('tax_settings.set_default', $taxSetting->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('PUT')
                                                <button type="submit" class="btn btn-outline-primary btn-sm">تعيين كافتراضي</button>
                                            </form>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('tax_settings.edit', $taxSetting->id) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if(!$taxSetting->is_default)
                                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $taxSetting->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            @endif
                                        </div>
                                        
                                        <!-- Modal -->
                                        @if(!$taxSetting->is_default)
                                            <div class="modal fade" id="deleteModal{{ $taxSetting->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف إعداد الضريبة "{{ $taxSetting->name }}"؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('tax_settings.destroy', $taxSetting->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد إعدادات ضرائب</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection