@extends('layouts.modern')

@section('title', 'إضافة إعداد ضريبة جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة إعداد ضريبة جديد</h3>
                </div>
                <form action="{{ route('tax_settings.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="name">اسم الضريبة</label>
                            <input type="text" name="name" id="name" class="form-control" required value="{{ old('name') }}">
                            <small class="form-text text-muted">مثال: ضريبة القيمة المضافة، ضريبة المبيعات، إلخ.</small>
                        </div>

                        <div class="form-group">
                            <label for="rate">نسبة الضريبة (%)</label>
                            <input type="number" step="0.01" min="0" max="100" name="rate" id="rate" class="form-control" required value="{{ old('rate') }}">
                            <small class="form-text text-muted">أدخل النسبة المئوية للضريبة. مثال: 15 لضريبة 15%</small>
                        </div>

                        <div class="form-group">
                            <label for="description">الوصف</label>
                            <textarea name="description" id="description" class="form-control" rows="3">{{ old('description') }}</textarea>
                            <small class="form-text text-muted">وصف اختياري لتوضيح الغرض من هذه الضريبة</small>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">نشط</label>
                            </div>
                            <small class="form-text text-muted">تحديد ما إذا كان هذا الإعداد نشطًا ويمكن استخدامه في الفواتير</small>
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_default" name="is_default" value="1" {{ old('is_default') == '1' ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_default">افتراضي</label>
                            </div>
                            <small class="form-text text-muted">تحديد ما إذا كان هذا الإعداد هو الافتراضي للفواتير الجديدة</small>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ</button>
                        <a href="{{ route('tax_settings.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection