@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقرير ضريبة القيمة المضافة #{{ $taxReport->report_number }}</h4>
                    <div>
                        <a href="{{ route('tax-reports.export', $taxReport->id) }}" class="btn btn-secondary" target="_blank">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </a>
                        @if($taxReport->status == 'draft')
                            <form action="{{ route('tax-reports.submit', $taxReport->id) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-paper-plane"></i> تقديم التقرير
                                </button>
                            </form>
                        @endif
                        @if($taxReport->status == 'submitted')
                            <form action="{{ route('tax-reports.approve', $taxReport->id) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-check"></i> اعتماد التقرير
                                </button>
                            </form>
                            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal">
                                <i class="fas fa-times"></i> رفض التقرير
                            </button>
                        @endif
                        <a href="{{ route('tax-reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>معلومات التقرير</h5>
                            <p><strong>رقم التقرير:</strong> {{ $taxReport->report_number }}</p>
                            <p><strong>الفترة:</strong> {{ $taxReport->start_date->format('Y-m-d') }} إلى {{ $taxReport->end_date->format('Y-m-d') }}</p>
                            <p><strong>تاريخ الإنشاء:</strong> {{ $taxReport->created_at->format('Y-m-d') }}</p>
                            <p><strong>الحالة:</strong> 
                                @if($taxReport->status == 'draft')
                                    <span class="badge bg-secondary">مسودة</span>
                                @elseif($taxReport->status == 'submitted')
                                    <span class="badge bg-info">مقدم</span>
                                @elseif($taxReport->status == 'approved')
                                    <span class="badge bg-success">معتمد</span>
                                @elseif($taxReport->status == 'rejected')
                                    <span class="badge bg-danger">مرفوض</span>
                                @endif
                            </p>
                            @if($taxReport->submitted_at)
                                <p><strong>تاريخ التقديم:</strong> {{ $taxReport->submitted_at->format('Y-m-d') }}</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h5>ملخص الضرائب</h5>
                            <p><strong>إجمالي الضريبة المحصلة:</strong> {{ number_format($taxReport->total_tax_collected, 2) }}</p>
                            <p><strong>إجمالي الضريبة المدفوعة:</strong> {{ number_format($taxReport->total_tax_paid, 2) }}</p>
                            <p><strong>صافي الضريبة:</strong> {{ number_format($taxReport->net_tax, 2) }}</p>
                        </div>
                    </div>

                    <h5 class="mt-4 mb-3">الفواتير المشمولة في التقرير</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>رقم الفاتورة</th>
                                    <th>العميل</th>
                                    <th>تاريخ الفاتورة</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>نسبة الضريبة</th>
                                    <th>مبلغ الضريبة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoices as $invoice)
                                    <tr>
                                        <td>
                                            <a href="{{ route('invoices.show', $invoice->id) }}">{{ $invoice->invoice_number }}</a>
                                        </td>
                                        <td>{{ $invoice->customer->name }}</td>
                                        <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                        <td>{{ $invoice->tax_rate }}%</td>
                                        <td>{{ number_format($invoice->tax_amount, 2) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">لا توجد فواتير في هذه الفترة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="5" class="text-left"><strong>إجمالي الضريبة المحصلة:</strong></td>
                                    <td><strong>{{ number_format($taxReport->total_tax_collected, 2) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    @if($taxReport->notes)
                        <div class="mt-4">
                            <h5>ملاحظات</h5>
                            <p>{{ $taxReport->notes }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Rejecting Report -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('tax-reports.reject', $taxReport->id) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">رفض التقرير</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="reason">سبب الرفض</label>
                        <textarea name="reason" id="reason" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">رفض</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection