<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير ضريبة القيمة المضافة - {{ $taxReport->report_number }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
        }
        .company-info {
            margin-bottom: 20px;
        }
        .report-info {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .report-info h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .summary {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .summary h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .notes {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير ضريبة القيمة المضافة</h1>
        <p>{{ $taxReport->report_number }}</p>
    </div>

    <div class="company-info">
        <h3>معلومات الشركة</h3>
        <p><strong>اسم الشركة:</strong> {{ $taxReport->company->name }}</p>
        <p><strong>الرقم الضريبي:</strong> {{ $taxReport->company->tax_number ?? 'غير متوفر' }}</p>
        <p><strong>العنوان:</strong> {{ $taxReport->company->address }}</p>
    </div>

    <div class="report-info">
        <h3>معلومات التقرير</h3>
        <p><strong>رقم التقرير:</strong> {{ $taxReport->report_number }}</p>
        <p><strong>الفترة:</strong> {{ $taxReport->start_date->format('Y-m-d') }} إلى {{ $taxReport->end_date->format('Y-m-d') }}</p>
        <p><strong>تاريخ الإنشاء:</strong> {{ $taxReport->created_at->format('Y-m-d') }}</p>
        <p><strong>الحالة:</strong> 
            @if($taxReport->status == 'draft')
                مسودة
            @elseif($taxReport->status == 'submitted')
                مقدم
            @elseif($taxReport->status == 'approved')
                معتمد
            @elseif($taxReport->status == 'rejected')
                مرفوض
            @endif
        </p>
        @if($taxReport->submitted_at)
            <p><strong>تاريخ التقديم:</strong> {{ $taxReport->submitted_at->format('Y-m-d') }}</p>
        @endif
    </div>

    <div class="summary">
        <h3>ملخص الضرائب</h3>
        <p><strong>إجمالي الضريبة المحصلة:</strong> {{ number_format($taxReport->total_tax_collected, 2) }}</p>
        <p><strong>إجمالي الضريبة المدفوعة:</strong> {{ number_format($taxReport->total_tax_paid, 2) }}</p>
        <p><strong>صافي الضريبة:</strong> {{ number_format($taxReport->net_tax, 2) }}</p>
    </div>

    <h3>الفواتير المشمولة في التقرير</h3>
    <table>
        <thead>
            <tr>
                <th>رقم الفاتورة</th>
                <th>العميل</th>
                <th>تاريخ الفاتورة</th>
                <th>المبلغ الإجمالي</th>
                <th>نسبة الضريبة</th>
                <th>مبلغ الضريبة</th>
            </tr>
        </thead>
        <tbody>
            @forelse($invoices as $invoice)
                <tr>
                    <td>{{ $invoice->invoice_number }}</td>
                    <td>{{ $invoice->customer->name }}</td>
                    <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                    <td>{{ number_format($invoice->total_amount, 2) }}</td>
                    <td>{{ $invoice->tax_rate }}%</td>
                    <td>{{ number_format($invoice->tax_amount, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" style="text-align: center;">لا توجد فواتير في هذه الفترة</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr>
                <td colspan="5" style="text-align: left;"><strong>إجمالي الضريبة المحصلة:</strong></td>
                <td><strong>{{ number_format($taxReport->total_tax_collected, 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    @if($taxReport->notes)
        <div class="notes">
            <h3>ملاحظات</h3>
            <p>{{ $taxReport->notes }}</p>
        </div>
    @endif

    <div class="footer">
        <p>تم إنشاء هذا التقرير بواسطة نظام إدارة المصاعد - {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>