@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقارير الضرائب</h4>
                    <div>
                        <a href="{{ route('tax-reports.generate-form') }}" class="btn btn-primary">إنشاء تقرير ضريبي جديد</a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم التقرير</th>
                                    <th>الفترة</th>
                                    <th>إجمالي الضريبة المحصلة</th>
                                    <th>إجمالي الضريبة المدفوعة</th>
                                    <th>صافي الضريبة</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($taxReports as $report)
                                    <tr>
                                        <td>{{ $report->report_number }}</td>
                                        <td>{{ $report->start_date->format('Y-m-d') }} إلى {{ $report->end_date->format('Y-m-d') }}</td>
                                        <td>{{ number_format($report->total_tax_collected, 2) }}</td>
                                        <td>{{ number_format($report->total_tax_paid, 2) }}</td>
                                        <td>{{ number_format($report->net_tax, 2) }}</td>
                                        <td>
                                            @if($report->status == 'draft')
                                                <span class="badge bg-secondary">مسودة</span>
                                            @elseif($report->status == 'submitted')
                                                <span class="badge bg-info">مقدم</span>
                                            @elseif($report->status == 'approved')
                                                <span class="badge bg-success">معتمد</span>
                                            @elseif($report->status == 'rejected')
                                                <span class="badge bg-danger">مرفوض</span>
                                            @endif
                                        </td>
                                        <td>{{ $report->created_at->format('Y-m-d') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('tax-reports.show', $report->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($report->status == 'draft')
                                                    <form action="{{ route('tax-reports.submit', $report->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        <button type="submit" class="btn btn-primary btn-sm" title="تقديم">
                                                            <i class="fas fa-paper-plane"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                                <a href="{{ route('tax-reports.export', $report->id) }}" class="btn btn-secondary btn-sm" title="تصدير PDF" target="_blank">
                                                    <i class="fas fa-file-pdf"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد تقارير ضريبية</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $taxReports->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection