@extends('layouts.app')

@section('title', 'إعدادات الشركة')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">إعدادات الشركة</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item active">إعدادات الشركة</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">معلومات الشركة</h3>
                        @if(auth()->user()->hasPermission('edit_company_settings'))
                        <div class="card-tools">
                            <a href="{{ route('company_settings.edit') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                        </div>
                        @endif
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>اسم الشركة</label>
                                    <p class="form-control-static">{{ $settings->company_name }}</p>
                                </div>
                                <div class="form-group">
                                    <label>عنوان الشركة</label>
                                    <p class="form-control-static">{{ $settings->company_address ?: 'غير محدد' }}</p>
                                </div>
                                <div class="form-group">
                                    <label>رقم الهاتف</label>
                                    <p class="form-control-static">{{ $settings->company_phone ?: 'غير محدد' }}</p>
                                </div>
                                <div class="form-group">
                                    <label>البريد الإلكتروني</label>
                                    <p class="form-control-static">{{ $settings->company_email ?: 'غير محدد' }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>الموقع الإلكتروني</label>
                                    <p class="form-control-static">
                                        @if($settings->company_website)
                                        <a href="{{ $settings->company_website }}" target="_blank">{{ $settings->company_website }}</a>
                                        @else
                                        غير محدد
                                        @endif
                                    </p>
                                </div>
                                <div class="form-group">
                                    <label>الرقم الضريبي</label>
                                    <p class="form-control-static">{{ $settings->tax_number ?: 'غير محدد' }}</p>
                                </div>
                                <div class="form-group">
                                    <label>السجل التجاري</label>
                                    <p class="form-control-static">{{ $settings->commercial_record ?: 'غير محدد' }}</p>
                                </div>
                                <div class="form-group">
                                    <label>شعار الشركة</label>
                                    <div>
                                        @if($settings->logo_path)
                                        <img src="{{ asset('storage/' . $settings->logo_path) }}" alt="شعار الشركة" class="img-thumbnail" style="max-height: 100px;">
                                        @else
                                        <p class="form-control-static">لا يوجد شعار</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection