@extends('layouts.app')

@section('title', 'تعديل إعدادات الشركة')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تعديل إعدادات الشركة</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('company_settings.index') }}">إعدادات الشركة</a></li>
                    <li class="breadcrumb-item active">تعديل</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif
                
                @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                @endif

                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">معلومات الشركة</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('company_settings.update') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="company_name">اسم الشركة <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="company_name" name="company_name" value="{{ old('company_name', $settings->company_name) }}" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="company_address">عنوان الشركة</label>
                                        <textarea class="form-control" id="company_address" name="company_address" rows="3">{{ old('company_address', $settings->company_address) }}</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label for="company_phone">رقم الهاتف</label>
                                        <input type="text" class="form-control" id="company_phone" name="company_phone" value="{{ old('company_phone', $settings->company_phone) }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="company_email">البريد الإلكتروني</label>
                                        <input type="email" class="form-control" id="company_email" name="company_email" value="{{ old('company_email', $settings->company_email) }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="company_website">الموقع الإلكتروني</label>
                                        <input type="url" class="form-control" id="company_website" name="company_website" value="{{ old('company_website', $settings->company_website) }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="tax_number">الرقم الضريبي</label>
                                        <input type="text" class="form-control" id="tax_number" name="tax_number" value="{{ old('tax_number', $settings->tax_number) }}">
                                    </div>
                                    <div class="form-group">
                                        <label for="commercial_record">السجل التجاري</label>
                                        <input type="text" class="form-control" id="commercial_record" name="commercial_record" value="{{ old('commercial_record', $settings->commercial_record) }}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('company_settings.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">شعار الشركة</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <form action="{{ route('company_settings.upload_logo') }}" method="POST" enctype="multipart/form-data" id="logoForm">
                                    @csrf
                                    <div class="form-group">
                                        <label for="logo">تحميل شعار جديد</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="logo" name="logo" accept="image/jpeg,image/png,image/gif,image/jpg" required>
                                                <label class="custom-file-label" for="logo">اختر ملف</label>
                                            </div>
                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-primary" id="uploadButton">رفع</button>
                                            </div>
                                        </div>
                                        <small class="form-text text-muted">الصيغ المسموحة: JPG, JPEG, PNG, GIF. الحد الأقصى للحجم: 2 ميجابايت.</small>
                                        <div class="mt-2" id="uploadStatus" style="display: none;">
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%"></div>
                                            </div>
                                            <small class="text-muted">جاري رفع الشعار...</small>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="col-md-6 text-center">
                                <div class="form-group">
                                    <label>الشعار الحالي</label>
                                    <div>
                                        @if($settings->logo_path)
                                        <img src="{{ asset('storage/' . $settings->logo_path) }}" alt="شعار الشركة" class="img-thumbnail" style="max-height: 150px;">
                                        @else
                                        <p class="form-control-static">لا يوجد شعار</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // تحديث اسم الملف المختار في حقل رفع الشعار
    $(document).ready(function() {
        // تحديث اسم الملف عند اختياره
        $('.custom-file-input').on('change', function() {
            var fileName = $(this).val().split('\\').pop();
            $(this).next('.custom-file-label').html(fileName);
        });
        
        // عرض مؤشر التقدم عند رفع الملف
        $('#logoForm').on('submit', function() {
            var fileInput = $('#logo');
            var fileSize = fileInput[0].files[0] ? fileInput[0].files[0].size : 0;
            var maxSize = 2 * 1024 * 1024; // 2MB
            
            // التحقق من حجم الملف
            if (fileSize > maxSize) {
                alert('حجم الملف كبير جدًا. الحد الأقصى هو 2 ميجابايت.');
                return false;
            }
            
            // التحقق من نوع الملف
            var fileType = fileInput[0].files[0] ? fileInput[0].files[0].type : '';
            var allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/jpg'];
            
            if (allowedTypes.indexOf(fileType) === -1) {
                alert('نوع الملف غير مسموح به. الأنواع المسموح بها هي: JPG, JPEG, PNG, GIF');
                return false;
            }
            
            // إظهار مؤشر التقدم
            $('#uploadStatus').show();
            $('#uploadButton').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> جاري الرفع...');
            
            // تحديث شريط التقدم (محاكاة)
            var progress = 0;
            var interval = setInterval(function() {
                progress += 10;
                if (progress <= 90) {
                    $('.progress-bar').css('width', progress + '%').attr('aria-valuenow', progress);
                }
                if (progress >= 90) {
                    clearInterval(interval);
                }
            }, 300);
            
            return true;
        });
    });
</script>
@endpush