@extends('layouts.app')

@section('title', 'تفاصيل مرتجع المبيعات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل مرتجع المبيعات #{{ $salesReturn->return_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('sales-returns.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @if($salesReturn->status == 'draft')
                            <a href="{{ route('sales-returns.edit', $salesReturn) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <form action="{{ route('sales-returns.approve', $salesReturn) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('هل أنت متأكد من اعتماد هذا المرتجع؟')">
                                    <i class="fas fa-check"></i> اعتماد
                                </button>
                            </form>
                        @endif
                        @if($salesReturn->status != 'cancelled')
                            <form action="{{ route('sales-returns.cancel', $salesReturn) }}" method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من إلغاء هذا المرتجع؟')">
                                    <i class="fas fa-times"></i> إلغاء
                                </button>
                            </form>
                        @endif
                        <button class="btn btn-info btn-sm" onclick="window.print()">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات المرتجع</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="30%">رقم المرتجع</th>
                                            <td>{{ $salesReturn->return_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ المرتجع</th>
                                            <td>{{ $salesReturn->return_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($salesReturn->status == 'draft')
                                                    <span class="badge badge-warning">مسودة</span>
                                                @elseif($salesReturn->status == 'approved')
                                                    <span class="badge badge-success">معتمد</span>
                                                @elseif($salesReturn->status == 'cancelled')
                                                    <span class="badge badge-danger">ملغي</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المستودع</th>
                                            <td>{{ $salesReturn->warehouse->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفاتورة الأصلية</th>
                                            <td>
                                                @if($salesReturn->invoice)
                                                    <a href="{{ route('invoices.show', $salesReturn->invoice) }}">
                                                        {{ $salesReturn->invoice->invoice_number }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير مرتبط بفاتورة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $salesReturn->creator->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $salesReturn->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        @if($salesReturn->approved_at)
                                            <tr>
                                                <th>تم الاعتماد بواسطة</th>
                                                <td>{{ $salesReturn->approver->name ?? 'غير محدد' }}</td>
                                            </tr>
                                            <tr>
                                                <th>تاريخ الاعتماد</th>
                                                <td>{{ $salesReturn->approved_at->format('Y-m-d H:i') }}</td>
                                            </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات العميل</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th width="30%">اسم العميل</th>
                                            <td>{{ $salesReturn->customer->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td>{{ $salesReturn->customer->phone }}</td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $salesReturn->customer->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $salesReturn->customer->address }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم الضريبي</th>
                                            <td>{{ $salesReturn->customer->tax_number }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">بنود المرتجع</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الصنف</th>
                                                    <th>الكمية</th>
                                                    <th>سعر الوحدة</th>
                                                    <th>نسبة الضريبة %</th>
                                                    <th>مبلغ الضريبة</th>
                                                    <th>مبلغ الخصم</th>
                                                    <th>الإجمالي</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($salesReturn->items as $index => $item)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $item->item->name }} ({{ $item->item->sku }})</td>
                                                        <td>{{ $item->quantity }}</td>
                                                        <td>{{ number_format($item->unit_price, 2) }}</td>
                                                        <td>{{ $item->tax_rate }}%</td>
                                                        <td>{{ number_format($item->tax_amount, 2) }}</td>
                                                        <td>{{ number_format($item->discount_amount, 2) }}</td>
                                                        <td>{{ number_format($item->total_amount, 2) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th colspan="7" class="text-left">المجموع الفرعي</th>
                                                    <th>{{ number_format($salesReturn->subtotal, 2) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="7" class="text-left">مبلغ الضريبة</th>
                                                    <th>{{ number_format($salesReturn->tax_amount, 2) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="7" class="text-left">مبلغ الخصم</th>
                                                    <th>{{ number_format($salesReturn->discount_amount, 2) }}</th>
                                                </tr>
                                                <tr>
                                                    <th colspan="7" class="text-left">المجموع الكلي</th>
                                                    <th>{{ number_format($salesReturn->total_amount, 2) }}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($salesReturn->notes || $salesReturn->internal_notes)
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">الملاحظات</h5>
                                    </div>
                                    <div class="card-body">
                                        @if($salesReturn->notes)
                                            <div class="form-group">
                                                <label>ملاحظات عامة:</label>
                                                <p>{{ $salesReturn->notes }}</p>
                                            </div>
                                        @endif
                                        @if($salesReturn->internal_notes)
                                            <div class="form-group">
                                                <label>ملاحظات داخلية:</label>
                                                <p>{{ $salesReturn->internal_notes }}</p>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($salesReturn->journalEntries->count() > 0)
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">القيود المحاسبية</h5>
                                    </div>
                                    <div class="card-body">
                                        @foreach($salesReturn->journalEntries as $entry)
                                            <div class="card mb-3">
                                                <div class="card-header">
                                                    <h6 class="card-title">
                                                        قيد محاسبي #{{ $entry->id }} - {{ $entry->entry_date->format('Y-m-d') }}
                                                    </h6>
                                                </div>
                                                <div class="card-body">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <th>الحساب</th>
                                                                    <th>الوصف</th>
                                                                    <th>مدين</th>
                                                                    <th>دائن</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach($entry->items as $item)
                                                                    <tr>
                                                                        <td>{{ $item->account->name }}</td>
                                                                        <td>{{ $item->description }}</td>
                                                                        <td>{{ number_format($item->debit, 2) }}</td>
                                                                        <td>{{ number_format($item->credit, 2) }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                            <tfoot>
                                                                <tr>
                                                                    <th colspan="2">المجموع</th>
                                                                    <th>{{ number_format($entry->items->sum('debit'), 2) }}</th>
                                                                    <th>{{ number_format($entry->items->sum('credit'), 2) }}</th>
                                                                </tr>
                                                            </tfoot>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($salesReturn->inventoryTransactions->count() > 0)
                        <div class="row mt-4">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">حركات المخزون</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>الصنف</th>
                                                        <th>المستودع</th>
                                                        <th>نوع الحركة</th>
                                                        <th>الكمية</th>
                                                        <th>تاريخ الحركة</th>
                                                        <th>ملاحظات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($salesReturn->inventoryTransactions as $index => $transaction)
                                                        <tr>
                                                            <td>{{ $index + 1 }}</td>
                                                            <td>{{ $transaction->item->name }}</td>
                                                            <td>{{ $transaction->warehouse->name }}</td>
                                                            <td>
                                                                @if($transaction->transaction_type == 'return_from_customer')
                                                                    <span class="badge badge-success">مرتجع من العميل</span>
                                                                @elseif($transaction->transaction_type == 'sale')
                                                                    <span class="badge badge-danger">إلغاء مرتجع</span>
                                                                @endif
                                                            </td>
                                                            <td>{{ $transaction->quantity }}</td>
                                                            <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                                            <td>{{ $transaction->notes }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .card-tools, .main-header, .main-sidebar, .main-footer, .alert {
            display: none !important;
        }
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        .card {
            box-shadow: none !important;
            border: 1px solid #ddd;
        }
    }
</style>
@endsection