@extends('layouts.app')

@section('title', 'مرتجعات المبيعات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مرتجعات المبيعات</h3>
                    <div class="card-tools">
                        <a href="{{ route('sales-returns.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إنشاء مرتجع مبيعات جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم المرتجع</th>
                                    <th>تاريخ المرتجع</th>
                                    <th>العميل</th>
                                    <th>المستودع</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($salesReturns as $salesReturn)
                                    <tr>
                                        <td>{{ $salesReturn->return_number }}</td>
                                        <td>{{ $salesReturn->return_date->format('Y-m-d') }}</td>
                                        <td>{{ $salesReturn->customer->name }}</td>
                                        <td>{{ $salesReturn->warehouse->name }}</td>
                                        <td>{{ number_format($salesReturn->total_amount, 2) }}</td>
                                        <td>
                                            @if($salesReturn->status == 'draft')
                                                <span class="badge badge-warning">مسودة</span>
                                            @elseif($salesReturn->status == 'approved')
                                                <span class="badge badge-success">معتمد</span>
                                            @elseif($salesReturn->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                            @endif
                                        </td>
                                        <td>{{ $salesReturn->created_at->format('Y-m-d') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('sales-returns.show', $salesReturn) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($salesReturn->status == 'draft')
                                                    <a href="{{ route('sales-returns.edit', $salesReturn) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('sales-returns.destroy', $salesReturn) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا المرتجع؟')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد مرتجعات مبيعات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $salesReturns->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection