@extends('layouts.app')

@section('title', 'تعديل مرتجع المبيعات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل مرتجع المبيعات #{{ $salesReturn->return_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('sales-returns.show', $salesReturn) }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للتفاصيل
                        </a>
                    </div>
                </div>
                <form action="{{ route('sales-returns.update', $salesReturn) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        @if(session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="return_number">رقم المرتجع</label>
                                    <input type="text" class="form-control @error('return_number') is-invalid @enderror" id="return_number" name="return_number" value="{{ old('return_number', $salesReturn->return_number) }}" required>
                                    @error('return_number')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="return_date">تاريخ المرتجع</label>
                                    <input type="date" class="form-control @error('return_date') is-invalid @enderror" id="return_date" name="return_date" value="{{ old('return_date', $salesReturn->return_date->format('Y-m-d')) }}" required>
                                    @error('return_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="customer_id">العميل</label>
                                    <select class="form-control select2 @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">اختر العميل</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id', $salesReturn->customer_id) == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="warehouse_id">المستودع</label>
                                    <select class="form-control select2 @error('warehouse_id') is-invalid @enderror" id="warehouse_id" name="warehouse_id" required>
                                        <option value="">اختر المستودع</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id', $salesReturn->warehouse_id) == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_id">الفاتورة الأصلية (اختياري)</label>
                                    <select class="form-control select2 @error('invoice_id') is-invalid @enderror" id="invoice_id" name="invoice_id">
                                        <option value="">اختر الفاتورة</option>
                                        @foreach($invoices as $invoice)
                                            <option value="{{ $invoice->id }}" {{ old('invoice_id', $salesReturn->invoice_id) == $invoice->id ? 'selected' : '' }}>
                                                {{ $invoice->invoice_number }} - {{ $invoice->customer->name }} - {{ number_format($invoice->total, 2) }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('invoice_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="1">{{ old('notes', $salesReturn->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr>

                        <h4>بنود المرتجع</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead>
                                    <tr>
                                        <th width="30%">الصنف</th>
                                        <th width="15%">الكمية</th>
                                        <th width="15%">سعر الوحدة</th>
                                        <th width="10%">نسبة الضريبة %</th>
                                        <th width="10%">مبلغ الخصم</th>
                                        <th width="15%">الإجمالي</th>
                                        <th width="5%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($salesReturn->items as $index => $item)
                                        <tr class="item-row">
                                            <td>
                                                <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                                <select class="form-control select2 item-select" name="items[{{ $index }}][item_id]" required>
                                                    <option value="">اختر الصنف</option>
                                                    @foreach($items as $inventoryItem)
                                                        <option value="{{ $inventoryItem->id }}" data-price="{{ $inventoryItem->selling_price }}" {{ $item->item_id == $inventoryItem->id ? 'selected' : '' }}>
                                                            {{ $inventoryItem->name }} ({{ $inventoryItem->sku }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <input type="hidden" name="items[{{ $index }}][invoice_item_id]" class="invoice-item-id" value="{{ $item->invoice_item_id }}">
                                            </td>
                                            <td>
                                                <input type="number" class="form-control item-quantity" name="items[{{ $index }}][quantity]" min="0.01" step="0.01" value="{{ $item->quantity }}" required>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control item-price" name="items[{{ $index }}][unit_price]" min="0" step="0.01" value="{{ $item->unit_price }}" required>
                                            </td>
                                            <td>
                                                <input type="number" class="form-control item-tax" name="items[{{ $index }}][tax_rate]" min="0" step="0.01" value="{{ $item->tax_rate }}">
                                            </td>
                                            <td>
                                                <input type="number" class="form-control item-discount" name="items[{{ $index }}][discount_amount]" min="0" step="0.01" value="{{ $item->discount_amount }}">
                                            </td>
                                            <td>
                                                <input type="number" class="form-control item-total" value="{{ $item->total_amount }}" readonly>
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-danger btn-sm remove-item">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="7">
                                            <button type="button" class="btn btn-success btn-sm" id="add-item">
                                                <i class="fas fa-plus"></i> إضافة صنف
                                            </button>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="internal_notes">ملاحظات داخلية</label>
                                    <textarea class="form-control @error('internal_notes') is-invalid @enderror" id="internal_notes" name="internal_notes" rows="3">{{ old('internal_notes', $salesReturn->internal_notes) }}</textarea>
                                    @error('internal_notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">المجموع الفرعي:</div>
                                            <div class="col-md-6 text-left" id="subtotal">{{ number_format($salesReturn->subtotal, 2) }}</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">مبلغ الضريبة:</div>
                                            <div class="col-md-6 text-left" id="tax-amount">{{ number_format($salesReturn->tax_amount, 2) }}</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">مبلغ الخصم:</div>
                                            <div class="col-md-6 text-left" id="discount-amount">{{ number_format($salesReturn->discount_amount, 2) }}</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6"><strong>المجموع الكلي:</strong></div>
                                            <div class="col-md-6 text-left"><strong id="total-amount">{{ number_format($salesReturn->total_amount, 2) }}</strong></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        <a href="{{ route('sales-returns.show', $salesReturn) }}" class="btn btn-default">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تهيئة السيلكت2
        $('.select2').select2();

        // عند تغيير الفاتورة
        $('#invoice_id').change(function() {
            var invoiceId = $(this).val();
            if (invoiceId) {
                $.ajax({
                    url: "{{ route('sales-returns.get-invoice-items') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        invoice_id: invoiceId
                    },
                    success: function(response) {
                        // تعيين العميل
                        $('#customer_id').val(response.customer_id).trigger('change');
                        
                        // حذف جميع الصفوف الحالية
                        $('.item-row').remove();
                        
                        // إضافة صفوف لبنود الفاتورة
                        if (response.items.length > 0) {
                            for (var i = 0; i < response.items.length; i++) {
                                var item = response.items[i];
                                addItemRow(item.item_id, item.quantity, item.unit_price, item.tax_rate || 15, item.discount_amount || 0, item.id);
                            }
                        } else {
                            // إضافة صف فارغ إذا لم تكن هناك بنود
                            addEmptyRow();
                        }
                        
                        // إعادة حساب المجاميع
                        calculateTotals();
                    }
                });
            }
        });

        // إضافة صف جديد
        $('#add-item').click(function() {
            addEmptyRow();
        });

        // حذف صف
        $(document).on('click', '.remove-item', function() {
            if ($('.item-row').length > 1) {
                $(this).closest('tr').remove();
                calculateTotals();
            } else {
                alert('يجب أن يكون هناك صف واحد على الأقل');
            }
        });

        // ربط الأحداث
        function bindEvents() {
            // عند تغيير الصنف
            $('.item-select').off('change').on('change', function() {
                var row = $(this).closest('tr');
                var selectedOption = $(this).find('option:selected');
                var price = selectedOption.data('price') || 0;
                row.find('.item-price').val(price);
                calculateItemTotal(row);
            });

            // عند تغيير الكمية أو السعر أو الضريبة أو الخصم
            $('.item-quantity, .item-price, .item-tax, .item-discount').off('input').on('input', function() {
                var row = $(this).closest('tr');
                calculateItemTotal(row);
            });
        }

        // حساب إجمالي الصف
        function calculateItemTotal(row) {
            var quantity = parseFloat(row.find('.item-quantity').val()) || 0;
            var price = parseFloat(row.find('.item-price').val()) || 0;
            var taxRate = parseFloat(row.find('.item-tax').val()) || 0;
            var discount = parseFloat(row.find('.item-discount').val()) || 0;
            
            var subtotal = quantity * price;
            var taxAmount = subtotal * (taxRate / 100);
            var total = subtotal + taxAmount - discount;
            
            row.find('.item-total').val(total.toFixed(2));
            
            calculateTotals();
        }

        // حساب المجاميع
        function calculateTotals() {
            var subtotal = 0;
            var taxAmount = 0;
            var discountAmount = 0;
            var totalAmount = 0;
            
            $('.item-row').each(function() {
                var quantity = parseFloat($(this).find('.item-quantity').val()) || 0;
                var price = parseFloat($(this).find('.item-price').val()) || 0;
                var taxRate = parseFloat($(this).find('.item-tax').val()) || 0;
                var discount = parseFloat($(this).find('.item-discount').val()) || 0;
                
                var rowSubtotal = quantity * price;
                var rowTaxAmount = rowSubtotal * (taxRate / 100);
                
                subtotal += rowSubtotal;
                taxAmount += rowTaxAmount;
                discountAmount += discount;
                totalAmount += rowSubtotal + rowTaxAmount - discount;
            });
            
            $('#subtotal').text(subtotal.toFixed(2));
            $('#tax-amount').text(taxAmount.toFixed(2));
            $('#discount-amount').text(discountAmount.toFixed(2));
            $('#total-amount').text(totalAmount.toFixed(2));
        }

        // إضافة صف فارغ
        function addEmptyRow() {
            var rowCount = $('.item-row').length;
            var newRow = $('<tr class="item-row"></tr>');
            
            newRow.html(`
                <td>
                    <select class="form-control select2 item-select" name="items[${rowCount}][item_id]" required>
                        <option value="">اختر الصنف</option>
                        @foreach($items as $item)
                            <option value="{{ $item->id }}" data-price="{{ $item->selling_price }}">
                                {{ $item->name }} ({{ $item->sku }})
                            </option>
                        @endforeach
                    </select>
                    <input type="hidden" name="items[${rowCount}][invoice_item_id]" class="invoice-item-id">
                </td>
                <td>
                    <input type="number" class="form-control item-quantity" name="items[${rowCount}][quantity]" min="0.01" step="0.01" value="1" required>
                </td>
                <td>
                    <input type="number" class="form-control item-price" name="items[${rowCount}][unit_price]" min="0" step="0.01" value="0" required>
                </td>
                <td>
                    <input type="number" class="form-control item-tax" name="items[${rowCount}][tax_rate]" min="0" step="0.01" value="15">
                </td>
                <td>
                    <input type="number" class="form-control item-discount" name="items[${rowCount}][discount_amount]" min="0" step="0.01" value="0">
                </td>
                <td>
                    <input type="number" class="form-control item-total" value="0" readonly>
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            `);
            
            // إضافة الصف الجديد
            $('#items-table tbody').append(newRow);
            
            // إعادة تهيئة السيلكت2 للصف الجديد
            newRow.find('.select2').select2();
            
            // إعادة ربط الأحداث
            bindEvents();
        }

        // إضافة صف بقيم محددة
        function addItemRow(itemId, quantity, price, taxRate, discount, invoiceItemId) {
            var rowCount = $('.item-row').length;
            var newRow = $('<tr class="item-row"></tr>');
            
            newRow.html(`
                <td>
                    <select class="form-control select2 item-select" name="items[${rowCount}][item_id]" required>
                        <option value="">اختر الصنف</option>
                        @foreach($items as $item)
                            <option value="{{ $item->id }}" data-price="{{ $item->selling_price }}" ${itemId == {{ $item->id }} ? 'selected' : ''}>
                                {{ $item->name }} ({{ $item->sku }})
                            </option>
                        @endforeach
                    </select>
                    <input type="hidden" name="items[${rowCount}][invoice_item_id]" class="invoice-item-id" value="${invoiceItemId || ''}">
                </td>
                <td>
                    <input type="number" class="form-control item-quantity" name="items[${rowCount}][quantity]" min="0.01" step="0.01" value="${quantity}" required>
                </td>
                <td>
                    <input type="number" class="form-control item-price" name="items[${rowCount}][unit_price]" min="0" step="0.01" value="${price}" required>
                </td>
                <td>
                    <input type="number" class="form-control item-tax" name="items[${rowCount}][tax_rate]" min="0" step="0.01" value="${taxRate}">
                </td>
                <td>
                    <input type="number" class="form-control item-discount" name="items[${rowCount}][discount_amount]" min="0" step="0.01" value="${discount}">
                </td>
                <td>
                    <input type="number" class="form-control item-total" value="${(quantity * price) + ((quantity * price) * (taxRate / 100)) - discount}" readonly>
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm remove-item">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            `);
            
            // إضافة الصف الجديد
            $('#items-table tbody').append(newRow);
            
            // تحديد الصنف المختار
            newRow.find('.item-select').val(itemId);
            
            // إعادة تهيئة السيلكت2 للصف الجديد
            newRow.find('.select2').select2();
            
            // إعادة ربط الأحداث
            bindEvents();
        }

        // تهيئة الأحداث عند تحميل الصفحة
        bindEvents();
        calculateTotals();
    });
</script>
@endsection