@extends('layouts.app')

@section('title', 'إنشاء مرتجع مبيعات جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إنشاء مرتجع مبيعات جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('sales-returns.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <form action="{{ route('sales-returns.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if(session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="return_number">رقم المرتجع</label>
                                    <input type="text" class="form-control @error('return_number') is-invalid @enderror" id="return_number" name="return_number" value="{{ old('return_number', $returnNumber) }}" required>
                                    @error('return_number')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="return_date">تاريخ المرتجع</label>
                                    <input type="date" class="form-control @error('return_date') is-invalid @enderror" id="return_date" name="return_date" value="{{ old('return_date', date('Y-m-d')) }}" required>
                                    @error('return_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="customer_id">العميل</label>
                                    <select class="form-control select2 @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">اختر العميل</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="warehouse_id">المستودع</label>
                                    <select class="form-control select2 @error('warehouse_id') is-invalid @enderror" id="warehouse_id" name="warehouse_id" required>
                                        <option value="">اختر المستودع</option>
                                        @foreach($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}" {{ old('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                                {{ $warehouse->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_id">الفاتورة الأصلية (اختياري)</label>
                                    <select class="form-control select2 @error('invoice_id') is-invalid @enderror" id="invoice_id" name="invoice_id">
                                        <option value="">اختر الفاتورة</option>
                                        @foreach($invoices as $invoice)
                                            <option value="{{ $invoice->id }}" {{ old('invoice_id') == $invoice->id ? 'selected' : '' }}>
                                                {{ $invoice->invoice_number }} - {{ $invoice->customer->name }} - {{ number_format($invoice->total, 2) }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('invoice_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="1">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr>

                        <h4>بنود المرتجع</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead>
                                    <tr>
                                        <th width="30%">الصنف</th>
                                        <th width="15%">الكمية</th>
                                        <th width="15%">سعر الوحدة</th>
                                        <th width="10%">نسبة الضريبة %</th>
                                        <th width="10%">مبلغ الخصم</th>
                                        <th width="15%">الإجمالي</th>
                                        <th width="5%"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="item-row">
                                        <td>
                                            <select class="form-control select2 item-select" name="items[0][item_id]" required>
                                                <option value="">اختر الصنف</option>
                                                @foreach($items as $item)
                                                    <option value="{{ $item->id }}" data-price="{{ $item->selling_price }}">
                                                        {{ $item->name }} ({{ $item->sku }})
                                                    </option>
                                                @endforeach
                                            </select>
                                            <input type="hidden" name="items[0][invoice_item_id]" class="invoice-item-id">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-quantity" name="items[0][quantity]" min="0.01" step="0.01" value="1" required>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-price" name="items[0][unit_price]" min="0" step="0.01" value="0" required>
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-tax" name="items[0][tax_rate]" min="0" step="0.01" value="15">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-discount" name="items[0][discount_amount]" min="0" step="0.01" value="0">
                                        </td>
                                        <td>
                                            <input type="number" class="form-control item-total" value="0" readonly>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger btn-sm remove-item">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="7">
                                            <button type="button" class="btn btn-success btn-sm" id="add-item">
                                                <i class="fas fa-plus"></i> إضافة صنف
                                            </button>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="internal_notes">ملاحظات داخلية</label>
                                    <textarea class="form-control @error('internal_notes') is-invalid @enderror" id="internal_notes" name="internal_notes" rows="3">{{ old('internal_notes') }}</textarea>
                                    @error('internal_notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">المجموع الفرعي:</div>
                                            <div class="col-md-6 text-left" id="subtotal">0.00</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">مبلغ الضريبة:</div>
                                            <div class="col-md-6 text-left" id="tax-amount">0.00</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">مبلغ الخصم:</div>
                                            <div class="col-md-6 text-left" id="discount-amount">0.00</div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6"><strong>المجموع الكلي:</strong></div>
                                            <div class="col-md-6 text-left"><strong id="total-amount">0.00</strong></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ</button>
                        <a href="{{ route('sales-returns.index') }}" class="btn btn-default">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تهيئة السيلكت2
        $('.select2').select2();

        // عند تغيير الفاتورة
        $('#invoice_id').change(function() {
            var invoiceId = $(this).val();
            if (invoiceId) {
                $.ajax({
                    url: "{{ route('sales-returns.get-invoice-items') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        invoice_id: invoiceId
                    },
                    success: function(response) {
                        // تعيين العميل
                        $('#customer_id').val(response.customer_id).trigger('change');
                        
                        // حذف جميع الصفوف الحالية
                        $('.item-row').not(':first').remove();
                        
                        // إعادة تعيين الصف الأول
                        var firstRow = $('.item-row:first');
                        firstRow.find('.item-select').val('').trigger('change');
                        firstRow.find('.item-quantity').val(1);
                        firstRow.find('.item-price').val(0);
                        firstRow.find('.item-tax').val(15);
                        firstRow.find('.item-discount').val(0);
                        firstRow.find('.item-total').val(0);
                        firstRow.find('.invoice-item-id').val('');
                        
                        // إضافة صفوف لبنود الفاتورة
                        if (response.items.length > 0) {
                            // تعيين الصف الأول
                            var firstItem = response.items[0];
                            firstRow.find('.item-select').val(firstItem.item_id).trigger('change');
                            firstRow.find('.item-quantity').val(firstItem.quantity);
                            firstRow.find('.item-price').val(firstItem.unit_price);
                            firstRow.find('.item-tax').val(firstItem.tax_rate || 15);
                            firstRow.find('.item-discount').val(firstItem.discount_amount || 0);
                            firstRow.find('.invoice-item-id').val(firstItem.id);
                            calculateItemTotal(firstRow);
                            
                            // إضافة باقي البنود
                            for (var i = 1; i < response.items.length; i++) {
                                var item = response.items[i];
                                addItemRow(item.item_id, item.quantity, item.unit_price, item.tax_rate || 15, item.discount_amount || 0, item.id);
                            }
                        }
                        
                        // إعادة حساب المجاميع
                        calculateTotals();
                    }
                });
            }
        });

        // إضافة صف جديد
        $('#add-item').click(function() {
            var rowCount = $('.item-row').length;
            var newRow = $('.item-row:first').clone();
            
            // إعادة تعيين القيم
            newRow.find('.item-select').val('').attr('name', 'items[' + rowCount + '][item_id]');
            newRow.find('.item-quantity').val(1).attr('name', 'items[' + rowCount + '][quantity]');
            newRow.find('.item-price').val(0).attr('name', 'items[' + rowCount + '][unit_price]');
            newRow.find('.item-tax').val(15).attr('name', 'items[' + rowCount + '][tax_rate]');
            newRow.find('.item-discount').val(0).attr('name', 'items[' + rowCount + '][discount_amount]');
            newRow.find('.item-total').val(0);
            newRow.find('.invoice-item-id').val('').attr('name', 'items[' + rowCount + '][invoice_item_id]');
            
            // إضافة الصف الجديد
            $('#items-table tbody').append(newRow);
            
            // إعادة تهيئة السيلكت2 للصف الجديد
            newRow.find('.select2').select2();
            
            // إعادة ربط الأحداث
            bindEvents();
        });

        // حذف صف
        $(document).on('click', '.remove-item', function() {
            if ($('.item-row').length > 1) {
                $(this).closest('tr').remove();
                calculateTotals();
            } else {
                alert('يجب أن يكون هناك صف واحد على الأقل');
            }
        });

        // ربط الأحداث
        function bindEvents() {
            // عند تغيير الصنف
            $('.item-select').off('change').on('change', function() {
                var row = $(this).closest('tr');
                var selectedOption = $(this).find('option:selected');
                var price = selectedOption.data('price') || 0;
                row.find('.item-price').val(price);
                calculateItemTotal(row);
            });

            // عند تغيير الكمية أو السعر أو الضريبة أو الخصم
            $('.item-quantity, .item-price, .item-tax, .item-discount').off('input change keyup').on('input change keyup', function() {
                var row = $(this).closest('tr');
                calculateItemTotal(row);
            });
            
            // تأكد من تحديث المجاميع عند تغيير أي قيمة
            $('.item-quantity, .item-price, .item-tax, .item-discount').off('blur').on('blur', function() {
                calculateTotals();
            });
        }

        // حساب إجمالي الصف
        function calculateItemTotal(row) {
            var quantity = parseFloat(row.find('.item-quantity').val()) || 0;
            var price = parseFloat(row.find('.item-price').val()) || 0;
            var taxRate = parseFloat(row.find('.item-tax').val()) || 0;
            var discount = parseFloat(row.find('.item-discount').val()) || 0;
            
            var subtotal = quantity * price;
            var taxAmount = subtotal * (taxRate / 100);
            var total = subtotal + taxAmount - discount;
            
            row.find('.item-total').val(total.toFixed(2));
            
            // تأكد من تحديث المجاميع بعد تغيير أي قيمة
            calculateTotals();
        }

        // حساب المجاميع
        function calculateTotals() {
            var subtotal = 0;
            var taxAmount = 0;
            var discountAmount = 0;
            var totalAmount = 0;
            
            // حساب المجاميع من جميع الصفوف
            $('.item-row').each(function() {
                var quantity = parseFloat($(this).find('.item-quantity').val()) || 0;
                var price = parseFloat($(this).find('.item-price').val()) || 0;
                var taxRate = parseFloat($(this).find('.item-tax').val()) || 0;
                var discount = parseFloat($(this).find('.item-discount').val()) || 0;
                
                var rowSubtotal = quantity * price;
                var rowTaxAmount = rowSubtotal * (taxRate / 100);
                
                subtotal += rowSubtotal;
                taxAmount += rowTaxAmount;
                discountAmount += discount;
                totalAmount += rowSubtotal + rowTaxAmount - discount;
            });
            
            // تحديث عناصر العرض بالقيم الجديدة
            $('#subtotal').text(subtotal.toFixed(2));
            $('#tax-amount').text(taxAmount.toFixed(2));
            $('#discount-amount').text(discountAmount.toFixed(2));
            $('#total-amount').text(totalAmount.toFixed(2));
            
            // طباعة القيم في وحدة التحكم للتصحيح
            console.log('Subtotal:', subtotal);
            console.log('Tax Amount:', taxAmount);
            console.log('Discount Amount:', discountAmount);
            console.log('Total Amount:', totalAmount);
        }

        // إضافة صف بقيم محددة
        function addItemRow(itemId, quantity, price, taxRate, discount, invoiceItemId) {
            var rowCount = $('.item-row').length;
            var newRow = $('.item-row:first').clone();
            
            // تعيين القيم
            newRow.find('.item-select').val(itemId).attr('name', 'items[' + rowCount + '][item_id]');
            newRow.find('.item-quantity').val(quantity).attr('name', 'items[' + rowCount + '][quantity]');
            newRow.find('.item-price').val(price).attr('name', 'items[' + rowCount + '][unit_price]');
            newRow.find('.item-tax').val(taxRate).attr('name', 'items[' + rowCount + '][tax_rate]');
            newRow.find('.item-discount').val(discount).attr('name', 'items[' + rowCount + '][discount_amount]');
            newRow.find('.invoice-item-id').val(invoiceItemId).attr('name', 'items[' + rowCount + '][invoice_item_id]');
            
            // حساب الإجمالي
            var subtotal = quantity * price;
            var taxAmount = subtotal * (taxRate / 100);
            var total = subtotal + taxAmount - discount;
            newRow.find('.item-total').val(total.toFixed(2));
            
            // إضافة الصف الجديد
            $('#items-table tbody').append(newRow);
            
            // إعادة تهيئة السيلكت2 للصف الجديد
            newRow.find('.select2').select2();
            
            // إعادة ربط الأحداث
            bindEvents();
        }

        // تهيئة الأحداث عند تحميل الصفحة
        bindEvents();
        
        // تأكد من حساب المجاميع عند تحميل الصفحة
        calculateTotals();
        
        // إعادة حساب المجاميع بعد تحميل الصفحة بالكامل
        $(window).on('load', function() {
            setTimeout(function() {
                calculateTotals();
            }, 500);
        });
    });
</script>
@endsection