@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل استخدام المكافأة</h5>
                    <div>
                        <a href="{{ route('reward-redemptions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات الاستخدام</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الاستخدام</th>
                                            <td>{{ $redemption->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>النقاط المستخدمة</th>
                                            <td>{{ $redemption->points_used }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاستخدام</th>
                                            <td>{{ $redemption->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المستخدم</th>
                                            <td>{{ $redemption->user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $redemption->notes ?: 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات العميل</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم العميل</th>
                                            <td>
                                                <a href="{{ route('customers.show', $redemption->customer_id) }}">
                                                    {{ $redemption->customer->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $redemption->customer->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td>{{ $redemption->customer->phone }}</td>
                                        </tr>
                                        <tr>
                                            <th>النقاط الحالية</th>
                                            <td>{{ $redemption->customer->getActiveLoyaltyPointsAttribute() }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات المكافأة</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم المكافأة</th>
                                            <td>
                                                <a href="{{ route('customer-rewards.show', $redemption->reward_id) }}">
                                                    {{ $redemption->reward->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>النقاط المطلوبة</th>
                                            <td>{{ $redemption->reward->points_required }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $redemption->reward->description ?: 'لا يوجد وصف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($redemption->reward->status)
                                                    @case('active')
                                                        <span class="badge bg-success">نشطة</span>
                                                        @break
                                                    @case('inactive')
                                                        <span class="badge bg-danger">غير نشطة</span>
                                                        @break
                                                @endswitch
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection