@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">استخدام المكافآت</h5>
                    <div>
                        <a href="{{ route('reward-redemptions.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> استخدام مكافأة جديدة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العميل</th>
                                    <th>المكافأة</th>
                                    <th>النقاط المستخدمة</th>
                                    <th>المستخدم</th>
                                    <th>تاريخ الاستخدام</th>
                                    <th>ملاحظات</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($redemptions as $redemption)
                                    <tr>
                                        <td>{{ $redemption->id }}</td>
                                        <td>
                                            <a href="{{ route('customers.show', $redemption->customer_id) }}">
                                                {{ $redemption->customer->name }}
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('customer-rewards.show', $redemption->reward_id) }}">
                                                {{ $redemption->reward->name }}
                                            </a>
                                        </td>
                                        <td>{{ $redemption->points_used }}</td>
                                        <td>{{ $redemption->user->name }}</td>
                                        <td>{{ $redemption->created_at->format('Y-m-d H:i') }}</td>
                                        <td>{{ Str::limit($redemption->notes, 30) ?: 'لا توجد ملاحظات' }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('reward-redemptions.show', $redemption->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <form action="{{ route('reward-redemptions.destroy', $redemption->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الاستخدام؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد استخدامات للمكافآت</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $redemptions->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection