@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">استخدام مكافأة جديدة</h5>
                    <a href="{{ route('reward-redemptions.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('reward-redemptions.store') }}">
                        @csrf

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">العميل <span class="text-danger">*</span></label>
                                    <select class="form-control @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">-- اختر العميل --</option>
                                        @foreach($customers as $customerItem)
                                            <option value="{{ $customerItem->id }}" {{ (old('customer_id', $customer_id ?? '') == $customerItem->id) ? 'selected' : '' }}>
                                                {{ $customerItem->name }} (النقاط المتاحة: {{ $customerItem->getActiveLoyaltyPointsAttribute() }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="reward_id">المكافأة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('reward_id') is-invalid @enderror" id="reward_id" name="reward_id" required>
                                        <option value="">-- اختر المكافأة --</option>
                                        @foreach($rewards as $reward)
                                            <option value="{{ $reward->id }}" {{ old('reward_id') == $reward->id ? 'selected' : '' }}>
                                                {{ $reward->name }} ({{ $reward->points_required }} نقطة)
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('reward_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> استخدام المكافأة
                                </button>
                                <a href="{{ route('reward-redemptions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection