@extends('layouts.app')

@section('title', 'تقارير المبيعات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقارير المبيعات</h3>
                </div>
                <div class="card-body">
                    <!-- فلتر البحث -->
                    <form method="GET" action="{{ route('reports.sales') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="start_date">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="end_date">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                            </div>
                        </div>
                    </form>

                    <!-- ملخص المبيعات -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-shopping-cart"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي المبيعات</span>
                                    <span class="info-box-number">{{ number_format($totalSales, 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-money-bill-wave"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي المدفوعات</span>
                                    <span class="info-box-number">{{ number_format($totalPayments, 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-file-invoice"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">عدد الفواتير</span>
                                    <span class="info-box-number">{{ $invoices->count() }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- المبيعات حسب العميل -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">المبيعات حسب العميل</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>العميل</th>
                                                <th>إجمالي المبيعات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($salesByCustomer as $sale)
                                            <tr>
                                                <td>{{ $sale['customer_name'] }}</td>
                                                <td>{{ number_format($sale['total'], 2) }} ريال</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">رسم بياني للمبيعات</h3>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container" style="height: 300px;">
                                        <canvas id="salesChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- قائمة الفواتير -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">قائمة الفواتير</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>رقم الفاتورة</th>
                                                <th>العميل</th>
                                                <th>التاريخ</th>
                                                <th>المبلغ الإجمالي</th>
                                                <th>المبلغ المدفوع</th>
                                                <th>الحالة</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($invoices as $invoice)
                                            <tr>
                                                <td>{{ $invoice->invoice_number }}</td>
                                                <td>{{ $invoice->customer ? $invoice->customer->name : 'غير معروف' }}</td>
                                                <td>{{ $invoice->invoice_date }}</td>
                                                <td>{{ number_format($invoice->total_amount, 2) }} ريال</td>
                                                <td>{{ number_format($invoice->paid_amount, 2) }} ريال</td>
                                                <td>
                                                    @if($invoice->status == 'paid')
                                                        <span class="badge badge-success">مدفوعة</span>
                                                    @elseif($invoice->status == 'partial')
                                                        <span class="badge badge-warning">مدفوعة جزئياً</span>
                                                    @else
                                                        <span class="badge badge-danger">غير مدفوعة</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات المبيعات حسب العميل
        var customerNames = {!! json_encode($salesByCustomer->pluck('customer_name')->toArray()) !!};
        var salesData = {!! json_encode($salesByCustomer->pluck('total')->toArray()) !!};
        
        // إنشاء الرسم البياني
        var ctx = document.getElementById('salesChart').getContext('2d');
        var salesChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: customerNames,
                datasets: [{
                    label: 'المبيعات حسب العميل',
                    data: salesData,
                    backgroundColor: 'rgba(60, 141, 188, 0.8)',
                    borderColor: 'rgba(60, 141, 188, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
</script>
@endsection