@extends('layouts.app')

@section('title', 'تقارير الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقارير الصيانة</h3>
                </div>
                <div class="card-body">
                    <!-- فلتر البحث -->
                    <form method="GET" action="{{ route('reports.maintenance') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="start_date">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="end_date">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                            </div>
                        </div>
                    </form>

                    <!-- ملخص الصيانة -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-file-contract"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">عقود الصيانة النشطة</span>
                                    <span class="info-box-number">{{ $activeContracts }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-tools"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">عمليات الصيانة</span>
                                    <span class="info-box-number">{{ $maintenanceLogs->count() }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-elevator"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المصاعد التي تمت صيانتها</span>
                                    <span class="info-box-number">{{ $elevatorsMaintained }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الصيانة حسب النوع -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">الصيانة حسب النوع</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>نوع الصيانة</th>
                                                <th>العدد</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($maintenanceByType as $maintenance)
                                            <tr>
                                                <td>
                                                    @if($maintenance['type'] == 'regular')
                                                        صيانة دورية
                                                    @elseif($maintenance['type'] == 'emergency')
                                                        صيانة طارئة
                                                    @elseif($maintenance['type'] == 'preventive')
                                                        صيانة وقائية
                                                    @else
                                                        {{ $maintenance['type'] }}
                                                    @endif
                                                </td>
                                                <td>{{ $maintenance['count'] }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">رسم بياني للصيانة</h3>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container" style="height: 300px;">
                                        <canvas id="maintenanceChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- قائمة سجلات الصيانة -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">سجلات الصيانة</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>رقم المصعد</th>
                                                <th>نوع الصيانة</th>
                                                <th>تاريخ الصيانة</th>
                                                <th>الفني المسؤول</th>
                                                <th>الحالة</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($maintenanceLogs as $log)
                                            <tr>
                                                <td>{{ $log->elevator ? $log->elevator->serial_number : 'غير معروف' }}</td>
                                                <td>
                                                    @if($log->maintenance_type == 'regular')
                                                        صيانة دورية
                                                    @elseif($log->maintenance_type == 'emergency')
                                                        صيانة طارئة
                                                    @elseif($log->maintenance_type == 'preventive')
                                                        صيانة وقائية
                                                    @else
                                                        {{ $log->maintenance_type }}
                                                    @endif
                                                </td>
                                                <td>{{ $log->maintenance_date }}</td>
                                                <td>{{ $log->technician ? $log->technician->name : 'غير معروف' }}</td>
                                                <td>
                                                    @if($log->status == 'completed')
                                                        <span class="badge badge-success">مكتملة</span>
                                                    @elseif($log->status == 'pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                    @elseif($log->status == 'in_progress')
                                                        <span class="badge badge-info">قيد التنفيذ</span>
                                                    @else
                                                        <span class="badge badge-secondary">{{ $log->status }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('maintenance-logs.show', $log->id) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات الصيانة حسب النوع
        var maintenanceTypes = {!! json_encode($maintenanceByType->map(function($item) {
            if ($item['type'] == 'regular') return 'صيانة دورية';
            elseif ($item['type'] == 'emergency') return 'صيانة طارئة';
            elseif ($item['type'] == 'preventive') return 'صيانة وقائية';
            else return $item['type'];
        })->toArray()) !!};
        
        var maintenanceCounts = {!! json_encode($maintenanceByType->pluck('count')->toArray()) !!};
        
        // إنشاء الرسم البياني
        var ctx = document.getElementById('maintenanceChart').getContext('2d');
        var maintenanceChart = new Chart(ctx, {
            type: 'pie',
            data: {
                labels: maintenanceTypes,
                datasets: [{
                    data: maintenanceCounts,
                    backgroundColor: [
                        'rgba(60, 141, 188, 0.8)',
                        'rgba(210, 214, 222, 0.8)',
                        'rgba(255, 193, 7, 0.8)',
                        'rgba(40, 167, 69, 0.8)',
                        'rgba(220, 53, 69, 0.8)'
                    ],
                    borderColor: [
                        'rgba(60, 141, 188, 1)',
                        'rgba(210, 214, 222, 1)',
                        'rgba(255, 193, 7, 1)',
                        'rgba(40, 167, 69, 1)',
                        'rgba(220, 53, 69, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    });
</script>
@endsection