@extends('layouts.app')

@section('title', 'تقارير المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقارير المخزون</h3>
                </div>
                <div class="card-body">
                    <!-- ملخص المخزون -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-warehouse"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي قيمة المخزون</span>
                                    <span class="info-box-number">{{ number_format($totalInventoryValue, 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-exclamation-triangle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">قطع غيار منخفضة المخزون</span>
                                    <span class="info-box-number">{{ $lowStockParts->count() }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- قطع الغيار منخفضة المخزون -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">قطع الغيار منخفضة المخزون</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>رقم القطعة</th>
                                                <th>اسم القطعة</th>
                                                <th>المخزون الحالي</th>
                                                <th>الحد الأدنى</th>
                                                <th>سعر الوحدة</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($lowStockParts as $part)
                                            <tr>
                                                <td>{{ $part->part_number }}</td>
                                                <td>{{ $part->name }}</td>
                                                <td>
                                                    <span class="badge badge-danger">{{ $part->current_stock }}</span>
                                                </td>
                                                <td>{{ $part->min_stock }}</td>
                                                <td>{{ number_format($part->unit_price, 2) }} ريال</td>
                                                <td>
                                                    <a href="{{ route('elevator-parts.edit-stock', $part->id) }}" class="btn btn-sm btn-warning">
                                                        <i class="fas fa-edit"></i> تعديل المخزون
                                                    </a>
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- أكثر قطع الغيار استخدامًا -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">أكثر قطع الغيار استخدامًا</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>اسم القطعة</th>
                                                <th>عدد مرات الاستخدام</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($mostUsedParts as $part)
                                            <tr>
                                                <td>{{ $part['part_name'] }}</td>
                                                <td>{{ $part['total_used'] }}</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">رسم بياني لأكثر قطع الغيار استخدامًا</h3>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container" style="height: 300px;">
                                        <canvas id="partsChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات قطع الغيار الأكثر استخدامًا
        var partNames = {!! json_encode(collect($mostUsedParts)->pluck('part_name')->toArray()) !!};
        var usageCounts = {!! json_encode(collect($mostUsedParts)->pluck('total_used')->toArray()) !!};
        
        // إنشاء الرسم البياني
        var ctx = document.getElementById('partsChart').getContext('2d');
        var partsChart = new Chart(ctx, {
            type: 'horizontalBar',
            data: {
                labels: partNames,
                datasets: [{
                    label: 'عدد مرات الاستخدام',
                    data: usageCounts,
                    backgroundColor: 'rgba(60, 141, 188, 0.8)',
                    borderColor: 'rgba(60, 141, 188, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    x: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
</script>
@endsection