@extends('layouts.app')

@section('title', 'التقارير')

@section('content')
<div class="container-fluid">
    <!-- ملخص الإحصائيات -->
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3>{{ number_format($totalInvoices) }}</h3>
                    <p>إجمالي الفواتير</p>
                </div>
                <div class="icon">
                    <i class="fas fa-file-invoice"></i>
                </div>
                <a href="{{ route('reports.sales') }}" class="small-box-footer">
                    المزيد من المعلومات <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>{{ number_format($totalPayments, 2) }} ريال</h3>
                    <p>إجمالي المدفوعات</p>
                </div>
                <div class="icon">
                    <i class="fas fa-money-bill-alt"></i>
                </div>
                <a href="{{ route('reports.financial') }}" class="small-box-footer">
                    المزيد من المعلومات <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3>{{ number_format($activeContracts) }}</h3>
                    <p>عقود الصيانة النشطة</p>
                </div>
                <div class="icon">
                    <i class="fas fa-tools"></i>
                </div>
                <a href="{{ route('reports.maintenance') }}" class="small-box-footer">
                    المزيد من المعلومات <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        
        <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
                <div class="inner">
                    <h3>{{ number_format($overdueAmount, 2) }} ريال</h3>
                    <p>المستحقات المتأخرة</p>
                </div>
                <div class="icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <a href="{{ route('reports.financial') }}" class="small-box-footer">
                    المزيد من المعلومات <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- أنواع التقارير -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">نظام التقارير</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير المبيعات</span>
                                    <span class="info-box-number">تحليل المبيعات والإيرادات</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <a href="{{ route('reports.sales') }}" class="small-box-footer">
                                        عرض التقارير <i class="fas fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-tools"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير الصيانة</span>
                                    <span class="info-box-number">تحليل أعمال الصيانة</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <a href="{{ route('reports.maintenance') }}" class="small-box-footer">
                                        عرض التقارير <i class="fas fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-warehouse"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير المخزون</span>
                                    <span class="info-box-number">تحليل حالة المخزون</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <a href="{{ route('reports.inventory') }}" class="small-box-footer">
                                        عرض التقارير <i class="fas fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3 col-sm-6 col-12">
                            <div class="info-box bg-danger">
                                <span class="info-box-icon"><i class="fas fa-money-bill-wave"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">التقارير المالية</span>
                                    <span class="info-box-number">تحليل الوضع المالي</span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <a href="{{ route('reports.financial') }}" class="small-box-footer">
                                        عرض التقارير <i class="fas fa-arrow-circle-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- معلومات الشركة -->
    @if(auth()->user()->company)
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">معلومات الشركة</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>اسم الشركة:</strong> {{ auth()->user()->company->name }}</p>
                            <p><strong>البريد الإلكتروني:</strong> {{ auth()->user()->company->email ?? 'غير متوفر' }}</p>
                            <p><strong>الهاتف:</strong> {{ auth()->user()->company->phone ?? 'غير متوفر' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>الرقم الضريبي:</strong> {{ auth()->user()->company->tax_number ?? 'غير متوفر' }}</p>
                            <p><strong>العملة:</strong> {{ auth()->user()->company->currency ?? 'ريال سعودي' }}</p>
                            <p><strong>العنوان:</strong> {{ auth()->user()->company->address ?? 'غير متوفر' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
@endsection