@extends('layouts.app')

@section('title', 'التقارير المالية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">التقارير المالية</h3>
                </div>
                <div class="card-body">
                    <!-- فلتر البحث -->
                    <form method="GET" action="{{ route('reports.financial') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="start_date">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="end_date">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">تطبيق الفلتر</button>
                            </div>
                        </div>
                    </form>

                    <!-- ملخص مالي -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-money-bill-alt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي الإيرادات</span>
                                    <span class="info-box-number">{{ number_format($totalRevenue, 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-hand-holding-usd"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي المدفوعات المستلمة</span>
                                    <span class="info-box-number">{{ number_format($totalPaymentsReceived, 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box bg-danger">
                                <span class="info-box-icon"><i class="fas fa-exclamation-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المستحقات المتأخرة</span>
                                    <span class="info-box-number">{{ number_format($overdueAmount, 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- الإيرادات حسب الشهر -->
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">الإيرادات حسب الشهر</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>الشهر</th>
                                                <th>الإيرادات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($revenueByMonth as $revenue)
                                            <tr>
                                                <td>{{ $revenue['month'] }}</td>
                                                <td>{{ number_format($revenue['total'], 2) }} ريال</td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">رسم بياني للإيرادات</h3>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container" style="height: 300px;">
                                        <canvas id="revenueChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- روابط للتقارير المالية المفصلة -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">تقارير مالية مفصلة</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <a href="{{ route('financial-reports.index') }}" class="btn btn-block btn-primary">
                                                <i class="fas fa-chart-line mr-2"></i> التقارير المالية المفصلة
                                            </a>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="{{ route('tax-reports.index') }}" class="btn btn-block btn-success">
                                                <i class="fas fa-percent mr-2"></i> تقارير الضرائب
                                            </a>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="{{ route('customer-statements.index') }}" class="btn btn-block btn-info">
                                                <i class="fas fa-file-invoice-dollar mr-2"></i> كشوف حساب العملاء
                                            </a>
                                        </div>
                                        <div class="col-md-3">
                                            <a href="{{ route('financial-reports.income-expense-form') }}" class="btn btn-block btn-warning">
                                                <i class="fas fa-balance-scale mr-2"></i> تقارير الإيرادات والمصروفات
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات الإيرادات حسب الشهر
        var months = {!! json_encode(collect($revenueByMonth)->pluck('month')->toArray()) !!};
        var revenues = {!! json_encode(collect($revenueByMonth)->pluck('total')->toArray()) !!};
        
        // إنشاء الرسم البياني
        var ctx = document.getElementById('revenueChart').getContext('2d');
        var revenueChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: months,
                datasets: [{
                    label: 'الإيرادات الشهرية',
                    data: revenues,
                    backgroundColor: 'rgba(60, 141, 188, 0.2)',
                    borderColor: 'rgba(60, 141, 188, 1)',
                    borderWidth: 2,
                    pointBackgroundColor: 'rgba(60, 141, 188, 1)',
                    pointRadius: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
</script>
@endsection