@extends('layouts.app')

@section('title', 'تقرير مدفوعات المصاعد قيد التركيب')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تقرير مدفوعات المصاعد قيد التركيب</h3>
                    <div>
                        <button onclick="window.print()" class="btn btn-dark">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('dashboard') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للوحة التحكم
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <!-- فلاتر البحث -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <form action="{{ route('reports.elevator-payments') }}" method="GET" class="form-inline">
                                <div class="form-group mx-2">
                                    <label for="customer_id" class="mx-2">العميل:</label>
                                    <select id="customer_id" name="customer_id" class="form-control">
                                        <option value="">الكل</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-2">
                                    <label for="elevator_id" class="mx-2">المصعد:</label>
                                    <select id="elevator_id" name="elevator_id" class="form-control">
                                        <option value="">الكل</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ request('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-2">
                                    <i class="fas fa-filter"></i> تصفية
                                </button>
                                <a href="{{ route('reports.elevator-payments') }}" class="btn btn-secondary">
                                    <i class="fas fa-sync"></i> إعادة تعيين
                                </a>
                            </form>
                        </div>
                    </div>

                    <!-- جدول التقرير -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رقم المصعد</th>
                                    <th>اسم العميل</th>
                                    <th>قيمة المصعد</th>
                                    <th>إجمالي المبالغ المدفوعة</th>
                                    <th>المتبقي من ثمن المصعد</th>
                                    <th>المشروع</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reportData as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <a href="{{ route('elevators.show', $item['elevator_id']) }}">
                                                {{ $item['serial_number'] }}
                                            </a>
                                        </td>
                                        <td>{{ $item['customer_name'] }}</td>
                                        <td>{{ number_format($item['elevator_price'], 2) }} ريال</td>
                                        <td>{{ number_format($item['total_payments'], 2) }} ريال</td>
                                        <td class="{{ $item['remaining_amount'] > 0 ? 'text-danger' : 'text-success' }}">
                                            {{ number_format($item['remaining_amount'], 2) }} ريال
                                        </td>
                                        <td>
                                            @if($item['project_id'])
                                                <a href="{{ route('installation-projects.show', $item['project_id']) }}">
                                                    {{ $item['project_title'] }}
                                                </a>
                                            @else
                                                {{ $item['project_title'] }}
                                            @endif
                                        </td>
                                        <td>
                                            @if($item['project_id'])
                                                <a href="{{ route('installation-projects.show', $item['project_id']) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> عرض المشروع
                                                </a>
                                            @else
                                                <span class="btn btn-sm btn-secondary disabled">
                                                    <i class="fas fa-ban"></i> لا يوجد مشروع
                                                </span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد بيانات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <th colspan="3" class="text-center">الإجمالي</th>
                                    <th>{{ number_format(array_sum(array_column($reportData, 'elevator_price')), 2) }} ريال</th>
                                    <th>{{ number_format(array_sum(array_column($reportData, 'total_payments')), 2) }} ريال</th>
                                    <th>{{ number_format(array_sum(array_column($reportData, 'remaining_amount')), 2) }} ريال</th>
                                    <th colspan="2"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @media print {
        .btn, .navbar, .sidebar, .footer, form {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-header {
            background-color: white !important;
            border-bottom: 1px solid #ddd !important;
        }
        body {
            padding: 0 !important;
            margin: 0 !important;
        }
        .container-fluid {
            padding: 0 !important;
            margin: 0 !important;
            width: 100% !important;
        }
    }
</style>
@endsection