@extends('layouts.modern')

@section('title', 'تفاصيل طلب المخزون')

@section('styles')
<style>
    .status-badge {
        font-size: 1rem;
    }
    .item-details {
        background-color: #f8f9fa;
        padding: 15px;
        margin-bottom: 15px;
        border-radius: 5px;
        border: 1px solid #dee2e6;
    }
    .item-header {
        border-bottom: 1px solid #dee2e6;
        padding-bottom: 10px;
        margin-bottom: 10px;
    }
    .fulfill-form {
        background-color: #e9ecef;
        padding: 10px;
        border-radius: 5px;
        margin-top: 10px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل طلب المخزون: {{ $request->request_number }}</h3>
                    <div>
                        <a href="{{ route('projects.inventory.index', $project->id) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right ml-1"></i> العودة للقائمة
                        </a>
                        
                        @if(!in_array($request->status, ['approved', 'partially_fulfilled', 'fulfilled']))
                            @can('update', $project)
                            <a href="{{ route('projects.inventory.edit', [$project->id, $request->id]) }}" class="btn btn-primary">
                                <i class="fas fa-edit ml-1"></i> تعديل
                            </a>
                            @endcan
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات الطلب</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الطلب</th>
                                            <td>{{ $request->request_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>المشروع</th>
                                            <td>{{ $project->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>المرحلة</th>
                                            <td>{{ $request->phase ? $request->phase->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($request->status)
                                                    @case('draft')
                                                        <span class="badge badge-secondary status-badge">مسودة</span>
                                                        @break
                                                    @case('pending')
                                                        <span class="badge badge-warning status-badge">قيد الانتظار</span>
                                                        @break
                                                    @case('approved')
                                                        <span class="badge badge-info status-badge">معتمد</span>
                                                        @break
                                                    @case('partially_fulfilled')
                                                        <span class="badge badge-primary status-badge">منفذ جزئياً</span>
                                                        @break
                                                    @case('fulfilled')
                                                        <span class="badge badge-success status-badge">مكتمل</span>
                                                        @break
                                                    @case('rejected')
                                                        <span class="badge badge-danger status-badge">مرفوض</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary status-badge">{{ $request->status }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>نسبة الإنجاز</th>
                                            <td>
                                                <div class="progress">
                                                    <div class="progress-bar bg-success" role="progressbar" style="width: {{ $request->progress_percentage }}%" aria-valuenow="{{ $request->progress_percentage }}" aria-valuemin="0" aria-valuemax="100">{{ $request->progress_percentage }}%</div>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات إضافية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">مقدم الطلب</th>
                                            <td>{{ $request->requester->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الطلب</th>
                                            <td>{{ $request->requested_date->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاحتياج</th>
                                            <td>{{ $request->required_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>معتمد بواسطة</th>
                                            <td>{{ $request->approver ? $request->approver->name : 'غير معتمد بعد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاعتماد</th>
                                            <td>{{ $request->approval_date ? $request->approval_date->format('Y-m-d H:i') : 'غير معتمد بعد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($request->notes)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    {{ $request->notes }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    @if($request->rejection_reason)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-danger text-white">
                                    <h5 class="mb-0">سبب الرفض</h5>
                                </div>
                                <div class="card-body">
                                    {{ $request->rejection_reason }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">عناصر الطلب</h5>
                                </div>
                                <div class="card-body">
                                    @if($request->status == 'pending')
                                        @can('approveInventoryRequests', $project)
                                        <div class="mb-4">
                                            <div class="d-flex justify-content-between">
                                                <form action="{{ route('projects.inventory.approve', [$project->id, $request->id]) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-success">
                                                        <i class="fas fa-check ml-1"></i> اعتماد الطلب
                                                    </button>
                                                </form>
                                                
                                                <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#rejectModal">
                                                    <i class="fas fa-times ml-1"></i> رفض الطلب
                                                </button>
                                            </div>
                                        </div>
                                        @endcan
                                    @endif
                                    
                                    @if(in_array($request->status, ['approved', 'partially_fulfilled']))
                                        @can('fulfillInventoryRequests', $project)
                                        <form action="{{ route('projects.inventory.fulfill', [$project->id, $request->id]) }}" method="POST" id="fulfill-form">
                                            @csrf
                                        @endcan
                                    @endif
                                    
                                    @forelse($request->items as $item)
                                    <div class="item-details">
                                        <div class="item-header d-flex justify-content-between">
                                            <h5>{{ $item->item->name }} ({{ $item->item->sku }})</h5>
                                            <div>
                                                @switch($item->status)
                                                    @case('pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                        @break
                                                    @case('approved')
                                                        <span class="badge badge-info">معتمد</span>
                                                        @break
                                                    @case('partially_fulfilled')
                                                        <span class="badge badge-primary">منفذ جزئياً</span>
                                                        @break
                                                    @case('fulfilled')
                                                        <span class="badge badge-success">مكتمل</span>
                                                        @break
                                                    @case('rejected')
                                                        <span class="badge badge-danger">مرفوض</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $item->status }}</span>
                                                @endswitch
                                                
                                                @switch($item->priority)
                                                    @case('low')
                                                        <span class="badge badge-secondary">أولوية منخفضة</span>
                                                        @break
                                                    @case('medium')
                                                        <span class="badge badge-info">أولوية متوسطة</span>
                                                        @break
                                                    @case('high')
                                                        <span class="badge badge-warning">أولوية عالية</span>
                                                        @break
                                                    @case('critical')
                                                        <span class="badge badge-danger">أولوية حرجة</span>
                                                        @break
                                                @endswitch
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-sm">
                                                    <tr>
                                                        <th style="width: 40%">المستودع</th>
                                                        <td>{{ $item->warehouse->name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>الكمية المطلوبة</th>
                                                        <td>{{ $item->quantity }} {{ $item->item->unit }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>الكمية المصروفة</th>
                                                        <td>{{ $item->fulfilled_quantity }} {{ $item->item->unit }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>الكمية المتبقية</th>
                                                        <td>{{ $item->remaining_quantity }} {{ $item->item->unit }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <table class="table table-sm">
                                                    <tr>
                                                        <th style="width: 40%">المهمة المرتبطة</th>
                                                        <td>{{ $item->task ? $item->task->name : 'غير محدد' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>نسبة التنفيذ</th>
                                                        <td>
                                                            <div class="progress">
                                                                <div class="progress-bar bg-success" role="progressbar" style="width: {{ $item->fulfillment_percentage }}%" aria-valuenow="{{ $item->fulfillment_percentage }}" aria-valuemin="0" aria-valuemax="100">{{ $item->fulfillment_percentage }}%</div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>ملاحظات</th>
                                                        <td>{{ $item->notes ?: 'لا توجد' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        
                                        @if(in_array($request->status, ['approved', 'partially_fulfilled']) && $item->remaining_quantity > 0)
                                            @can('fulfillInventoryRequests', $project)
                                            <div class="fulfill-form">
                                                <div class="form-group">
                                                    <label>صرف كمية</label>
                                                    <div class="input-group">
                                                        <input type="hidden" name="items[{{ $loop->index }}][id]" value="{{ $item->id }}">
                                                        <input type="number" name="items[{{ $loop->index }}][fulfill_quantity]" class="form-control" min="0" max="{{ $item->remaining_quantity }}" step="0.01" value="0">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text">{{ $item->item->unit }}</span>
                                                            <button type="button" class="btn btn-outline-success fulfill-max" data-max="{{ $item->remaining_quantity }}">الكل</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            @endcan
                                        @endif
                                    </div>
                                    @empty
                                    <div class="alert alert-warning">
                                        لا توجد عناصر في هذا الطلب
                                    </div>
                                    @endforelse
                                    
                                    @if(in_array($request->status, ['approved', 'partially_fulfilled']))
                                        @can('fulfillInventoryRequests', $project)
                                        <div class="text-center mt-3">
                                            <button type="submit" class="btn btn-primary btn-lg">
                                                <i class="fas fa-check-circle ml-1"></i> تنفيذ الصرف
                                            </button>
                                        </div>
                                        </form>
                                        @endcan
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal رفض الطلب -->
<div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="{{ route('projects.inventory.reject', [$project->id, $request->id]) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">رفض طلب المخزون</h5>
                    <button type="button" class="close ml-0 mr-auto" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="rejection_reason">سبب الرفض</label>
                        <textarea name="rejection_reason" id="rejection_reason" rows="4" class="form-control" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الرفض</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function() {
        // زر صرف الكمية القصوى
        $('.fulfill-max').on('click', function() {
            const max = $(this).data('max');
            $(this).closest('.fulfill-form').find('input[type="number"]').val(max);
        });
        
        // التحقق من صحة نموذج الصرف
        $('#fulfill-form').on('submit', function(e) {
            let hasQuantity = false;
            
            $('input[name$="[fulfill_quantity]"]').each(function() {
                if (parseFloat($(this).val()) > 0) {
                    hasQuantity = true;
                    return false;
                }
            });
            
            if (!hasQuantity) {
                e.preventDefault();
                alert('يرجى تحديد كمية للصرف لعنصر واحد على الأقل');
                return false;
            }
        });
    });
</script>
@endsection