@extends('layouts.modern')

@section('title', 'طلبات المخزون للمشروع')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">طلبات المخزون للمشروع: {{ $project->title }}</h3>
                    <div>
                        <a href="{{ route('projects.show', $project->id) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right ml-1"></i> العودة للمشروع
                        </a>
                        @can('update', $project)
                        <a href="{{ route('projects.inventory.create', $project->id) }}" class="btn btn-primary">
                            <i class="fas fa-plus ml-1"></i> إنشاء طلب جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم الطلب</th>
                                    <th>المرحلة</th>
                                    <th>تاريخ الطلب</th>
                                    <th>تاريخ الاحتياج</th>
                                    <th>الحالة</th>
                                    <th>مقدم الطلب</th>
                                    <th>عدد العناصر</th>
                                    <th>نسبة الإنجاز</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($requests as $request)
                                <tr>
                                    <td>{{ $request->request_number }}</td>
                                    <td>{{ $request->phase ? $request->phase->name : 'غير محدد' }}</td>
                                    <td>{{ $request->requested_date->format('Y-m-d') }}</td>
                                    <td>{{ $request->required_date->format('Y-m-d') }}</td>
                                    <td>
                                        @switch($request->status)
                                            @case('draft')
                                                <span class="badge badge-secondary">مسودة</span>
                                                @break
                                            @case('pending')
                                                <span class="badge badge-warning">قيد الانتظار</span>
                                                @break
                                            @case('approved')
                                                <span class="badge badge-info">معتمد</span>
                                                @break
                                            @case('partially_fulfilled')
                                                <span class="badge badge-primary">منفذ جزئياً</span>
                                                @break
                                            @case('fulfilled')
                                                <span class="badge badge-success">مكتمل</span>
                                                @break
                                            @case('rejected')
                                                <span class="badge badge-danger">مرفوض</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary">{{ $request->status }}</span>
                                        @endswitch
                                    </td>
                                    <td>{{ $request->requester->name }}</td>
                                    <td>{{ $request->total_items }}</td>
                                    <td>
                                        <div class="progress">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $request->progress_percentage }}%" aria-valuenow="{{ $request->progress_percentage }}" aria-valuemin="0" aria-valuemax="100">{{ $request->progress_percentage }}%</div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('projects.inventory.show', [$project->id, $request->id]) }}" class="btn btn-sm btn-info" title="عرض التفاصيل">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if(!in_array($request->status, ['approved', 'partially_fulfilled', 'fulfilled']))
                                                @can('update', $project)
                                                <a href="{{ route('projects.inventory.edit', [$project->id, $request->id]) }}" class="btn btn-sm btn-primary" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                
                                                <form action="{{ route('projects.inventory.destroy', [$project->id, $request->id]) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الطلب؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif
                                            
                                            @if($request->status == 'pending')
                                                @can('approveInventoryRequests', $project)
                                                <form action="{{ route('projects.inventory.approve', [$project->id, $request->id]) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-success" title="اعتماد">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </form>
                                                @endcan
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد طلبات مخزون لهذا المشروع</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $requests->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection