@extends('layouts.modern')

@section('title', 'إنشاء طلب مخزون جديد')

@section('styles')
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<style>
    .item-row {
        background-color: #f8f9fa;
        padding: 10px;
        margin-bottom: 10px;
        border-radius: 5px;
        border: 1px solid #dee2e6;
    }
    .remove-item {
        color: #dc3545;
        cursor: pointer;
    }
    .add-item-btn {
        margin-bottom: 20px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إنشاء طلب مخزون جديد للمشروع: {{ $project->title }}</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('projects.inventory.store', $project->id) }}" method="POST" id="inventory-request-form">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="phase_id">مرحلة المشروع</label>
                                    <select name="phase_id" id="phase_id" class="form-control select2 @error('phase_id') is-invalid @enderror">
                                        <option value="">-- اختر المرحلة --</option>
                                        @foreach($phases as $phase)
                                            <option value="{{ $phase->id }}" {{ old('phase_id') == $phase->id ? 'selected' : '' }}>
                                                {{ $phase->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('phase_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="required_date">تاريخ الاحتياج</label>
                                    <div class="input-group date" id="required_date_picker" data-target-input="nearest">
                                        <input type="text" name="required_date" id="required_date" class="form-control datetimepicker-input @error('required_date') is-invalid @enderror" data-target="#required_date_picker" value="{{ old('required_date') ?? date('Y-m-d', strtotime('+3 days')) }}">
                                        <div class="input-group-append" data-target="#required_date_picker" data-toggle="datetimepicker">
                                            <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                        </div>
                                    </div>
                                    @error('required_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" rows="3" class="form-control @error('notes') is-invalid @enderror">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <h4 class="mt-4 mb-3">عناصر الطلب</h4>
                        
                        <div id="items-container">
                            <!-- هنا سيتم إضافة عناصر الطلب ديناميكياً -->
                        </div>
                        
                        <div class="text-center add-item-btn">
                            <button type="button" class="btn btn-success" id="add-item">
                                <i class="fas fa-plus ml-1"></i> إضافة عنصر
                            </button>
                        </div>
                        
                        <div class="form-group text-center mt-4">
                            <a href="{{ route('projects.inventory.index', $project->id) }}" class="btn btn-secondary ml-2">
                                <i class="fas fa-times ml-1"></i> إلغاء
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save ml-1"></i> حفظ الطلب
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- قالب عنصر الطلب -->
<template id="item-template">
    <div class="item-row">
        <div class="row">
            <div class="col-md-11">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>العنصر</label>
                            <select name="items[INDEX][item_id]" class="form-control select2 item-select" required>
                                <option value="">-- اختر العنصر --</option>
                                @foreach($inventoryItems as $item)
                                    <option value="{{ $item->id }}" data-unit="{{ $item->unit }}">
                                        {{ $item->name }} ({{ $item->sku }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>المستودع</label>
                            <select name="items[INDEX][warehouse_id]" class="form-control select2 warehouse-select" required>
                                <option value="">-- اختر المستودع --</option>
                                @foreach($warehouses as $warehouse)
                                    <option value="{{ $warehouse->id }}">
                                        {{ $warehouse->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>الكمية</label>
                            <div class="input-group">
                                <input type="number" name="items[INDEX][quantity]" class="form-control quantity-input" min="0.01" step="0.01" required>
                                <div class="input-group-append">
                                    <span class="input-group-text unit-text"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>الأولوية</label>
                            <select name="items[INDEX][priority]" class="form-control">
                                <option value="low">منخفضة</option>
                                <option value="medium" selected>متوسطة</option>
                                <option value="high">عالية</option>
                                <option value="critical">حرجة</option>
                            </select>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>المهمة المرتبطة</label>
                            <select name="items[INDEX][task_id]" class="form-control select2">
                                <option value="">-- اختر المهمة --</option>
                                @foreach($project->phases as $phase)
                                    <optgroup label="{{ $phase->name }}">
                                        @foreach($phase->tasks as $task)
                                            <option value="{{ $task->id }}">{{ $task->name }}</option>
                                        @endforeach
                                    </optgroup>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>ملاحظات</label>
                    <textarea name="items[INDEX][notes]" class="form-control" rows="2"></textarea>
                </div>
            </div>
            
            <div class="col-md-1 text-center">
                <button type="button" class="btn btn-danger remove-item mt-4">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
        </div>
        
        <div class="row mt-2">
            <div class="col-md-12">
                <div class="availability-info alert alert-info d-none">
                    <i class="fas fa-info-circle ml-1"></i>
                    <span class="availability-text"></span>
                </div>
            </div>
        </div>
    </div>
</template>
@endsection

@section('scripts')
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>
<script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
<script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
<script>
    $(function() {
        // تهيئة التاريخ
        $('#required_date_picker').datetimepicker({
            format: 'YYYY-MM-DD',
            minDate: moment().add(1, 'days')
        });
        
        // تهيئة السيليكت 2
        $('.select2').select2({
            theme: 'bootstrap4',
            width: '100%'
        });
        
        // إضافة عنصر أول افتراضي
        addItem();
        
        // زر إضافة عنصر
        $('#add-item').on('click', function() {
            addItem();
        });
        
        // حذف عنصر
        $(document).on('click', '.remove-item', function() {
            if ($('.item-row').length > 1) {
                $(this).closest('.item-row').remove();
            } else {
                alert('يجب أن يحتوي الطلب على عنصر واحد على الأقل');
            }
        });
        
        // تحديث وحدة القياس عند اختيار العنصر
        $(document).on('change', '.item-select', function() {
            const row = $(this).closest('.item-row');
            const option = $(this).find('option:selected');
            const unit = option.data('unit') || '';
            
            row.find('.unit-text').text(unit);
            
            // التحقق من توفر العنصر في المستودع
            checkAvailability(row);
        });
        
        // التحقق من توفر العنصر عند تغيير المستودع
        $(document).on('change', '.warehouse-select', function() {
            const row = $(this).closest('.item-row');
            checkAvailability(row);
        });
        
        // التحقق من الكمية المتوفرة
        function checkAvailability(row) {
            const itemId = row.find('.item-select').val();
            const warehouseId = row.find('.warehouse-select').val();
            const availabilityInfo = row.find('.availability-info');
            const availabilityText = row.find('.availability-text');
            
            if (!itemId || !warehouseId) {
                availabilityInfo.addClass('d-none');
                return;
            }
            
            $.ajax({
                url: "{{ route('inventory.check-availability') }}",
                type: 'GET',
                data: {
                    item_id: itemId,
                    warehouse_id: warehouseId
                },
                success: function(response) {
                    availabilityInfo.removeClass('d-none');
                    
                    if (response.available > 0) {
                        availabilityInfo.removeClass('alert-warning alert-danger').addClass('alert-success');
                        availabilityText.html(`الكمية المتوفرة: <strong>${response.available} ${response.unit}</strong>`);
                    } else {
                        availabilityInfo.removeClass('alert-success alert-warning').addClass('alert-danger');
                        availabilityText.html(`<strong>غير متوفر في المستودع!</strong>`);
                    }
                },
                error: function() {
                    availabilityInfo.removeClass('d-none alert-success alert-danger').addClass('alert-warning');
                    availabilityText.html(`<strong>تعذر التحقق من المخزون</strong>`);
                }
            });
        }
        
        // إضافة عنصر جديد
        function addItem() {
            const template = $('#item-template').html();
            const index = $('.item-row').length;
            const newItem = template.replace(/INDEX/g, index);
            
            $('#items-container').append(newItem);
            
            // تهيئة السيليكت 2 للعناصر الجديدة
            $('.item-row:last-child .select2').select2({
                theme: 'bootstrap4',
                width: '100%'
            });
        }
        
        // التحقق من صحة النموذج قبل الإرسال
        $('#inventory-request-form').on('submit', function(e) {
            if ($('.item-row').length === 0) {
                e.preventDefault();
                alert('يجب إضافة عنصر واحد على الأقل للطلب');
                return false;
            }
            
            let valid = true;
            
            $('.item-row').each(function() {
                const itemId = $(this).find('.item-select').val();
                const warehouseId = $(this).find('.warehouse-select').val();
                const quantity = $(this).find('.quantity-input').val();
                
                if (!itemId || !warehouseId || !quantity || quantity <= 0) {
                    valid = false;
                    return false;
                }
            });
            
            if (!valid) {
                e.preventDefault();
                alert('يرجى ملء جميع بيانات العناصر بشكل صحيح');
                return false;
            }
        });
    });
</script>
@endsection