@extends('layouts.modern')

@section('title', 'تفاصيل الدفعة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل الدفعة #{{ $payment->payment_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('payments.receipt', $payment->id) }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print"></i> طباعة الإيصال
                        </a>
                        <a href="{{ route('payments.edit', $payment->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal">
                            <i class="fas fa-trash"></i> حذف
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الدفعة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>رقم الدفعة</th>
                                            <td>{{ $payment->payment_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ</th>
                                            <td>{{ number_format($payment->amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الدفع</th>
                                            <td>{{ $payment->payment_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>طريقة الدفع</th>
                                            <td>
                                                @if($payment->payment_method == 'cash')
                                                    نقدي
                                                @elseif($payment->payment_method == 'bank_transfer')
                                                    تحويل بنكي
                                                @elseif($payment->payment_method == 'check')
                                                    شيك
                                                @elseif($payment->payment_method == 'credit_card')
                                                    بطاقة ائتمان
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($payment->status == 'completed')
                                                    <span class="badge badge-success">مكتمل</span>
                                                @elseif($payment->status == 'pending')
                                                    <span class="badge badge-warning">قيد الانتظار</span>
                                                @elseif($payment->status == 'failed')
                                                    <span class="badge badge-danger">فشل</span>
                                                @elseif($payment->status == 'refunded')
                                                    <span class="badge badge-info">مسترجع</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $payment->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التحديث</th>
                                            <td>{{ $payment->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الفاتورة والعميل</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>رقم الفاتورة</th>
                                            <td>
                                                <a href="{{ route('invoices.show', $payment->invoice->id) }}">
                                                    {{ $payment->invoice->invoice_number }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>
                                                <a href="{{ route('customers.show', $payment->invoice->customer->id) }}">
                                                    {{ $payment->invoice->customer->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>إجمالي الفاتورة</th>
                                            <td>{{ number_format($payment->invoice->total_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ المدفوع</th>
                                            <td>{{ number_format($payment->invoice->paid_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ المتبقي</th>
                                            <td>{{ number_format($payment->invoice->remaining_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة الفاتورة</th>
                                            <td>
                                                @if($payment->invoice->status == 'paid')
                                                    <span class="badge badge-success">مدفوعة</span>
                                                @elseif($payment->invoice->status == 'partially_paid')
                                                    <span class="badge badge-warning">مدفوعة جزئياً</span>
                                                @elseif($payment->invoice->status == 'unpaid')
                                                    <span class="badge badge-danger">غير مدفوعة</span>
                                                @elseif($payment->invoice->status == 'overdue')
                                                    <span class="badge badge-danger">متأخرة</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($payment->payment_method == 'bank_transfer' && $payment->bank_transfer_reference)
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">تفاصيل التحويل البنكي</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>رقم التحويل:</strong> {{ $payment->bank_transfer_reference }}</p>
                            </div>
                        </div>
                    @endif

                    @if($payment->payment_method == 'check' && $payment->check_number)
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">تفاصيل الشيك</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>رقم الشيك:</strong> {{ $payment->check_number }}</p>
                                <p><strong>تاريخ الشيك:</strong> {{ $payment->check_date ? $payment->check_date->format('Y-m-d') : 'غير محدد' }}</p>
                                <p><strong>اسم البنك:</strong> {{ $payment->bank_name ?: 'غير محدد' }}</p>
                            </div>
                        </div>
                    @endif

                    @if($payment->payment_method == 'credit_card' && $payment->card_last_digits)
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">تفاصيل بطاقة الائتمان</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>آخر 4 أرقام من البطاقة:</strong> {{ $payment->card_last_digits }}</p>
                                <p><strong>رقم العملية:</strong> {{ $payment->transaction_id ?: 'غير محدد' }}</p>
                            </div>
                        </div>
                    @endif

                    @if($payment->notes)
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">ملاحظات</h5>
                            </div>
                            <div class="card-body">
                                <p>{{ $payment->notes }}</p>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('payments.index') }}" class="btn btn-secondary">العودة إلى قائمة المدفوعات</a>
                    
                    @if($payment->status == 'pending')
                        <form action="{{ route('payments.change-status', $payment->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="completed">
                            <button type="submit" class="btn btn-success">تأكيد الدفعة</button>
                        </form>
                    @endif
                    
                    @if($payment->status == 'completed')
                        <form action="{{ route('payments.change-status', $payment->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="refunded">
                            <button type="submit" class="btn btn-info">استرجاع الدفعة</button>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف هذه الدفعة؟
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                <form action="{{ route('payments.destroy', $payment->id) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection