<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إيصال دفع #{{ $payment->reference_number ?? $payment->id }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
        }
        .receipt {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 20px;
        }
        .receipt-header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 10px;
        }
        .receipt-header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .receipt-header p {
            margin: 5px 0;
            color: #666;
        }
        .receipt-body {
            margin-bottom: 20px;
        }
        .receipt-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .receipt-info-item {
            flex: 1;
        }
        .receipt-info-item h3 {
            margin-top: 0;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
            font-size: 16px;
        }
        .receipt-details {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .receipt-details th, .receipt-details td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .receipt-details th {
            background-color: #f5f5f5;
        }
        .receipt-total {
            text-align: left;
            margin-top: 20px;
            font-weight: bold;
            font-size: 16px;
        }
        .receipt-footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .signature {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
        }
        .signature-item {
            flex: 1;
            text-align: center;
            border-top: 1px solid #ddd;
            padding-top: 10px;
            margin: 0 20px;
        }
        @media print {
            body {
                padding: 0;
            }
            .receipt {
                border: none;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="receipt">
        <div class="receipt-header">
            <h1>إيصال دفع</h1>
            <p>{{ config('app.name') }}</p>
            <p>{{ $payment->invoice->company->name }}</p>
            <p>{{ $payment->invoice->company->address }}</p>
            <p>هاتف: {{ $payment->invoice->company->phone }}</p>
            <p>البريد الإلكتروني: {{ $payment->invoice->company->email }}</p>
        </div>

        <div class="receipt-body">
            <div class="receipt-info">
                <div class="receipt-info-item">
                    <h3>معلومات الدفع</h3>
                    <p><strong>رقم الإيصال:</strong> {{ $payment->reference_number ?? $payment->id }}</p>
                    <p><strong>تاريخ الدفع:</strong> {{ $payment->payment_date->format('Y-m-d') }}</p>
                    <p><strong>طريقة الدفع:</strong> 
                        @if($payment->payment_method_id == 1)
                            نقدي
                        @elseif($payment->payment_method_id == 2)
                            تحويل بنكي
                        @elseif($payment->payment_method_id == 3)
                            شيك
                        @elseif($payment->payment_method_id == 4)
                            بطاقة ائتمان
                        @else
                            {{ $payment->payment_method_id }}
                        @endif
                    </p>
                    <p><strong>الحالة:</strong> 
                        @if($payment->status == 'completed')
                            مكتمل
                        @elseif($payment->status == 'pending')
                            قيد الانتظار
                        @elseif($payment->status == 'failed')
                            فشل
                        @elseif($payment->status == 'refunded')
                            مسترجع
                        @endif
                    </p>
                </div>

                <div class="receipt-info-item">
                    <h3>معلومات العميل</h3>
                    <p><strong>اسم العميل:</strong> {{ $payment->invoice->customer->name }}</p>
                    <p><strong>العنوان:</strong> {{ $payment->invoice->customer->address }}</p>
                    <p><strong>الهاتف:</strong> {{ $payment->invoice->customer->phone }}</p>
                    <p><strong>البريد الإلكتروني:</strong> {{ $payment->invoice->customer->email }}</p>
                </div>
            </div>

            <h3>تفاصيل الدفع</h3>
            <table class="receipt-details">
                <thead>
                    <tr>
                        <th>الوصف</th>
                        <th>المبلغ</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>دفعة للفاتورة رقم {{ $payment->invoice->invoice_number }}</td>
                        <td>{{ number_format($payment->amount, 2) }}</td>
                    </tr>
                    @if($payment->payable_type == 'App\\Models\\InvoiceInstallment')
                        <tr>
                            <td>القسط رقم {{ $payment->payable->installment_number }}</td>
                            <td>{{ number_format($payment->payable->amount, 2) }}</td>
                        </tr>
                    @endif
                </tbody>
            </table>

            <div class="receipt-total">
                <p>إجمالي المبلغ المدفوع: {{ number_format($payment->amount, 2) }}</p>
            </div>

            @if($payment->payment_method_id == 2 && $payment->reference_number)
                <h3>تفاصيل التحويل البنكي</h3>
                <p><strong>رقم التحويل:</strong> {{ $payment->reference_number }}</p>
            @endif

            @if($payment->payment_method_id == 3)
                <h3>تفاصيل الشيك</h3>
                <p><strong>رقم المرجع:</strong> {{ $payment->reference_number ?: 'غير محدد' }}</p>
            @endif

            @if($payment->payment_method_id == 4)
                <h3>تفاصيل بطاقة الائتمان</h3>
                <p><strong>رقم المرجع:</strong> {{ $payment->reference_number ?: 'غير محدد' }}</p>
            @endif

            @if($payment->notes)
                <h3>ملاحظات</h3>
                <p>{{ $payment->notes }}</p>
            @endif

            <div class="signature">
                <div class="signature-item">
                    <p>توقيع المستلم</p>
                </div>
                <div class="signature-item">
                    <p>توقيع العميل</p>
                </div>
            </div>
        </div>

        <div class="receipt-footer">
            <p>تم إنشاء هذا الإيصال بواسطة {{ config('app.name') }} بتاريخ {{ now()->format('Y-m-d H:i') }}</p>
            <p>هذا الإيصال صالح بدون ختم أو توقيع</p>
        </div>
    </div>

    <div class="no-print" style="text-align: center; margin-top: 20px;">
        <button onclick="window.print();" style="padding: 10px 20px; background-color: #4CAF50; color: white; border: none; border-radius: 4px; cursor: pointer;">طباعة الإيصال</button>
        <button onclick="window.close();" style="padding: 10px 20px; background-color: #f44336; color: white; border: none; border-radius: 4px; cursor: pointer; margin-right: 10px;">إغلاق</button>
    </div>
</body>
</html>