@extends('layouts.modern')

@section('title', 'قائمة المدفوعات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة المدفوعات</h3>
                    <div class="card-tools">
                        <a href="{{ route('payments.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة دفعة جديدة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رقم الدفعة</th>
                                    <th>العميل</th>
                                    <th>الفاتورة</th>
                                    <th>المبلغ</th>
                                    <th>طريقة الدفع</th>
                                    <th>تاريخ الدفع</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($payments as $payment)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $payment->payment_number }}</td>
                                    <td>{{ $payment->invoice->customer->name }}</td>
                                    <td>
                                        <a href="{{ route('invoices.show', $payment->invoice->id) }}">
                                            {{ $payment->invoice->invoice_number }}
                                        </a>
                                    </td>
                                    <td>{{ number_format($payment->amount, 2) }}</td>
                                    <td>{{ $payment->payment_method }}</td>
                                    <td>{{ $payment->payment_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($payment->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($payment->status == 'pending')
                                            <span class="badge badge-warning">قيد الانتظار</span>
                                        @elseif($payment->status == 'failed')
                                            <span class="badge badge-danger">فشل</span>
                                        @elseif($payment->status == 'refunded')
                                            <span class="badge badge-info">مسترجع</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('payments.show', $payment->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('payments.edit', $payment->id) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="{{ route('payments.receipt', $payment->id) }}" class="btn btn-success btn-sm" target="_blank">
                                                <i class="fas fa-print"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $payment->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                        
                                        <!-- Modal -->
                                        <div class="modal fade" id="deleteModal{{ $payment->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        هل أنت متأكد من حذف هذه الدفعة؟
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                        <form action="{{ route('payments.destroy', $payment->id) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد مدفوعات</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer clearfix">
                    {{ $payments->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection