@extends('layouts.modern')

@section('title', 'تعديل الدفعة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل الدفعة #{{ $payment->payment_number }}</h3>
                </div>
                <form action="{{ route('payments.update', $payment->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>الفاتورة</label>
                                    <input type="text" class="form-control" value="{{ $payment->invoice->invoice_number }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>العميل</label>
                                    <input type="text" class="form-control" value="{{ $payment->invoice->customer->name }}" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">المبلغ</label>
                                    <input type="number" step="0.01" name="amount" id="amount" class="form-control" required value="{{ old('amount', $payment->amount) }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_date">تاريخ الدفع</label>
                                    <input type="date" name="payment_date" id="payment_date" class="form-control" required value="{{ old('payment_date', $payment->payment_date->format('Y-m-d')) }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_method">طريقة الدفع</label>
                                    <select name="payment_method" id="payment_method" class="form-control" required>
                                        <option value="cash" {{ old('payment_method', $payment->payment_method) == 'cash' ? 'selected' : '' }}>نقدي</option>
                                        <option value="bank_transfer" {{ old('payment_method', $payment->payment_method) == 'bank_transfer' ? 'selected' : '' }}>تحويل بنكي</option>
                                        <option value="check" {{ old('payment_method', $payment->payment_method) == 'check' ? 'selected' : '' }}>شيك</option>
                                        <option value="credit_card" {{ old('payment_method', $payment->payment_method) == 'credit_card' ? 'selected' : '' }}>بطاقة ائتمان</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="completed" {{ old('status', $payment->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="pending" {{ old('status', $payment->status) == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="failed" {{ old('status', $payment->status) == 'failed' ? 'selected' : '' }}>فشل</option>
                                        <option value="refunded" {{ old('status', $payment->status) == 'refunded' ? 'selected' : '' }}>مسترجع</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="form-group payment-details" id="bank_transfer_details" style="display: none;">
                            <label for="bank_transfer_reference">رقم التحويل البنكي</label>
                            <input type="text" name="bank_transfer_reference" id="bank_transfer_reference" class="form-control" value="{{ old('bank_transfer_reference', $payment->bank_transfer_reference) }}">
                        </div>

                        <div class="form-group payment-details" id="check_details" style="display: none;">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="check_number">رقم الشيك</label>
                                        <input type="text" name="check_number" id="check_number" class="form-control" value="{{ old('check_number', $payment->check_number) }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="check_date">تاريخ الشيك</label>
                                        <input type="date" name="check_date" id="check_date" class="form-control" value="{{ old('check_date', $payment->check_date ? $payment->check_date->format('Y-m-d') : '') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="bank_name">اسم البنك</label>
                                <input type="text" name="bank_name" id="bank_name" class="form-control" value="{{ old('bank_name', $payment->bank_name) }}">
                            </div>
                        </div>

                        <div class="form-group payment-details" id="credit_card_details" style="display: none;">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="card_last_digits">آخر 4 أرقام من البطاقة</label>
                                        <input type="text" name="card_last_digits" id="card_last_digits" class="form-control" maxlength="4" value="{{ old('card_last_digits', $payment->card_last_digits) }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="transaction_id">رقم العملية</label>
                                        <input type="text" name="transaction_id" id="transaction_id" class="form-control" value="{{ old('transaction_id', $payment->transaction_id) }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control" rows="3">{{ old('notes', $payment->notes) }}</textarea>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        <a href="{{ route('payments.show', $payment->id) }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // عرض تفاصيل طريقة الدفع المناسبة
        $('#payment_method').change(function() {
            $('.payment-details').hide();
            var method = $(this).val();
            if (method === 'bank_transfer') {
                $('#bank_transfer_details').show();
            } else if (method === 'check') {
                $('#check_details').show();
            } else if (method === 'credit_card') {
                $('#credit_card_details').show();
            }
        });

        // تشغيل التغيير عند تحميل الصفحة
        $('#payment_method').trigger('change');
    });
</script>
@endsection