@extends('layouts.modern')

@section('title', 'إضافة دفعة جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة دفعة جديدة</h3>
                </div>
                <form action="{{ route('payments.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if(isset($invoice))
                            <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>الفاتورة</label>
                                        <input type="text" class="form-control" value="{{ $invoice->invoice_number }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>العميل</label>
                                        <input type="text" class="form-control" value="{{ $invoice->customer->name }}" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>إجمالي الفاتورة</label>
                                        <input type="text" class="form-control" value="{{ number_format($invoice->total_amount, 2) }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>المبلغ المتبقي</label>
                                        <input type="text" class="form-control" value="{{ number_format($invoice->remaining_amount, 2) }}" readonly>
                                    </div>
                                </div>
                            </div>

                            @if($invoice->installments->count() > 0)
                                <div class="form-group">
                                    <label>القسط</label>
                                    <select name="installment_id" class="form-control">
                                        <option value="">دفعة للفاتورة بالكامل</option>
                                        @foreach($invoice->installments as $installment)
                                            @if($installment->status != 'paid')
                                                <option value="{{ $installment->id }}">
                                                    القسط {{ $installment->installment_number }} - 
                                                    المبلغ: {{ number_format($installment->amount, 2) }} - 
                                                    تاريخ الاستحقاق: {{ $installment->due_date->format('Y-m-d') }}
                                                </option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                        @else
                            <div class="form-group">
                                <label for="invoice_id">الفاتورة</label>
                                <select name="invoice_id" id="invoice_id" class="form-control" required>
                                    <option value="">اختر الفاتورة</option>
                                    @foreach($invoices as $invoice)
                                        <option value="{{ $invoice->id }}">
                                            {{ $invoice->invoice_number }} - 
                                            {{ $invoice->customer->name }} - 
                                            المبلغ: {{ number_format($invoice->total_amount, 2) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">المبلغ</label>
                                    <input type="number" step="0.01" name="amount" id="amount" class="form-control" required value="{{ old('amount') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_date">تاريخ الدفع</label>
                                    <input type="date" name="payment_date" id="payment_date" class="form-control" required value="{{ old('payment_date', date('Y-m-d')) }}">
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="reference_number">رقم المرجع</label>
                            <input type="text" name="reference_number" id="reference_number" class="form-control" value="{{ old('reference_number') }}">
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_method_id">طريقة الدفع</label>
                                    <select name="payment_method_id" id="payment_method" class="form-control" required>
                                        <option value="">-- اختر طريقة الدفع --</option>
                                        <option value="1" {{ old('payment_method_id') == 1 ? 'selected' : '' }}>نقدي</option>
                                        <option value="2" {{ old('payment_method_id') == 2 ? 'selected' : '' }}>تحويل بنكي</option>
                                        <option value="3" {{ old('payment_method_id') == 3 ? 'selected' : '' }}>شيك</option>
                                        <option value="4" {{ old('payment_method_id') == 4 ? 'selected' : '' }}>بطاقة ائتمان</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="form-group payment-details" id="bank_transfer_details" style="display: none;">
                            <label for="bank_transfer_reference">رقم التحويل البنكي</label>
                            <input type="text" name="bank_transfer_reference" id="bank_transfer_reference" class="form-control" value="{{ old('bank_transfer_reference') }}">
                        </div>

                        <div class="form-group payment-details" id="check_details" style="display: none;">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="check_number">رقم الشيك</label>
                                        <input type="text" name="check_number" id="check_number" class="form-control" value="{{ old('check_number') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="check_date">تاريخ الشيك</label>
                                        <input type="date" name="check_date" id="check_date" class="form-control" value="{{ old('check_date') }}">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="bank_name">اسم البنك</label>
                                <input type="text" name="bank_name" id="bank_name" class="form-control" value="{{ old('bank_name') }}">
                            </div>
                        </div>

                        <div class="form-group payment-details" id="credit_card_details" style="display: none;">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="card_last_digits">آخر 4 أرقام من البطاقة</label>
                                        <input type="text" name="card_last_digits" id="card_last_digits" class="form-control" maxlength="4" value="{{ old('card_last_digits') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="transaction_id">رقم العملية</label>
                                        <input type="text" name="transaction_id" id="transaction_id" class="form-control" value="{{ old('transaction_id') }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control" rows="3">{{ old('notes') }}</textarea>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ</button>
                        <a href="{{ route('payments.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // عرض تفاصيل طريقة الدفع المناسبة
        $('#payment_method').change(function() {
            $('.payment-details').hide();
            var methodId = $(this).val();
            var methodText = $(this).find('option:selected').text().toLowerCase();
            
            if (methodText.includes('تحويل') || methodText.includes('بنك')) {
                $('#bank_transfer_details').show();
            } else if (methodText.includes('شيك')) {
                $('#check_details').show();
            } else if (methodText.includes('بطاقة') || methodText.includes('ائتمان')) {
                $('#credit_card_details').show();
            }
        });

        // تشغيل التغيير عند تحميل الصفحة
        $('#payment_method').trigger('change');
    });
</script>
@endsection