@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل الفرصة التجارية</h5>
                    <div>
                        <a href="{{ route('opportunities.edit', $opportunity->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('opportunities.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات الفرصة</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الفرصة</th>
                                            <td>{{ $opportunity->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $opportunity->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>النوع</th>
                                            <td>
                                                @switch($opportunity->type)
                                                    @case('new_sale')
                                                        <span class="badge bg-primary">بيع جديد</span>
                                                        @break
                                                    @case('upgrade')
                                                        <span class="badge bg-success">ترقية</span>
                                                        @break
                                                    @case('maintenance')
                                                        <span class="badge bg-info">صيانة</span>
                                                        @break
                                                    @case('consultation')
                                                        <span class="badge bg-secondary">استشارة</span>
                                                        @break
                                                    @default
                                                        <span class="badge bg-dark">أخرى</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المرحلة</th>
                                            <td>
                                                @switch($opportunity->stage)
                                                    @case('lead')
                                                        <span class="badge bg-secondary">عميل محتمل</span>
                                                        @break
                                                    @case('qualified')
                                                        <span class="badge bg-info">مؤهل</span>
                                                        @break
                                                    @case('proposal')
                                                        <span class="badge bg-primary">عرض سعر</span>
                                                        @break
                                                    @case('negotiation')
                                                        <span class="badge bg-warning">تفاوض</span>
                                                        @break
                                                    @case('closed_won')
                                                        <span class="badge bg-success">مغلق (ناجح)</span>
                                                        @break
                                                    @case('closed_lost')
                                                        <span class="badge bg-danger">مغلق (خاسر)</span>
                                                        @break
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المبلغ</th>
                                            <td>{{ number_format($opportunity->amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>احتمالية الإغلاق</th>
                                            <td>{{ $opportunity->probability }}%</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإغلاق المتوقع</th>
                                            <td>{{ $opportunity->expected_close_date ? $opportunity->expected_close_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإغلاق الفعلي</th>
                                            <td>{{ $opportunity->actual_close_date ? $opportunity->actual_close_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>مصدر الفرصة</th>
                                            <td>{{ $opportunity->source ?: 'غير محدد' }}</td>
                                        </tr>
                                        @if($opportunity->stage == 'closed_lost')
                                        <tr>
                                            <th>سبب الخسارة</th>
                                            <td>{{ $opportunity->loss_reason ?: 'غير محدد' }}</td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات العميل</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم العميل</th>
                                            <td>
                                                <a href="{{ route('customers.show', $opportunity->customer_id) }}">
                                                    {{ $opportunity->customer->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $opportunity->customer->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td>{{ $opportunity->customer->phone }}</td>
                                        </tr>
                                        <tr>
                                            <th>المسؤول</th>
                                            <td>{{ $opportunity->user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $opportunity->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $opportunity->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">الوصف والملاحظات</h6>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <h6>وصف الفرصة:</h6>
                                        <p>{{ $opportunity->description ?: 'لا يوجد وصف' }}</p>
                                    </div>
                                    <div>
                                        <h6>ملاحظات:</h6>
                                        <p>{{ $opportunity->notes ?: 'لا توجد ملاحظات' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h6 class="mb-0">التفاعلات المرتبطة</h6>
                                    <a href="{{ route('customer-interactions.create', ['customer_id' => $opportunity->customer_id]) }}" class="btn btn-sm btn-primary">
                                        <i class="fas fa-plus"></i> إضافة تفاعل
                                    </a>
                                </div>
                                <div class="card-body">
                                    @if($opportunity->interactions->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>النوع</th>
                                                        <th>العنوان</th>
                                                        <th>تاريخ التفاعل</th>
                                                        <th>الحالة</th>
                                                        <th>النتيجة</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($opportunity->interactions as $interaction)
                                                        <tr>
                                                            <td>{{ $interaction->id }}</td>
                                                            <td>
                                                                @switch($interaction->type)
                                                                    @case('call')
                                                                        <span class="badge bg-primary">مكالمة</span>
                                                                        @break
                                                                    @case('meeting')
                                                                        <span class="badge bg-success">اجتماع</span>
                                                                        @break
                                                                    @case('email')
                                                                        <span class="badge bg-info">بريد إلكتروني</span>
                                                                        @break
                                                                    @case('note')
                                                                        <span class="badge bg-secondary">ملاحظة</span>
                                                                        @break
                                                                    @case('task')
                                                                        <span class="badge bg-warning">مهمة</span>
                                                                        @break
                                                                    @default
                                                                        <span class="badge bg-dark">أخرى</span>
                                                                @endswitch
                                                            </td>
                                                            <td>{{ $interaction->title }}</td>
                                                            <td>{{ $interaction->interaction_date->format('Y-m-d H:i') }}</td>
                                                            <td>
                                                                @switch($interaction->status)
                                                                    @case('pending')
                                                                        <span class="badge bg-warning">قيد الانتظار</span>
                                                                        @break
                                                                    @case('completed')
                                                                        <span class="badge bg-success">مكتمل</span>
                                                                        @break
                                                                    @case('cancelled')
                                                                        <span class="badge bg-danger">ملغي</span>
                                                                        @break
                                                                @endswitch
                                                            </td>
                                                            <td>
                                                                @switch($interaction->outcome)
                                                                    @case('positive')
                                                                        <span class="badge bg-success">إيجابي</span>
                                                                        @break
                                                                    @case('negative')
                                                                        <span class="badge bg-danger">سلبي</span>
                                                                        @break
                                                                    @case('neutral')
                                                                        <span class="badge bg-secondary">محايد</span>
                                                                        @break
                                                                    @case('pending')
                                                                        <span class="badge bg-warning">قيد الانتظار</span>
                                                                        @break
                                                                @endswitch
                                                            </td>
                                                            <td>
                                                                <a href="{{ route('customer-interactions.show', $interaction->id) }}" class="btn btn-sm btn-info">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <p class="text-center">لا توجد تفاعلات مرتبطة بهذه الفرصة</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection