@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الفرص التجارية</h5>
                    <div>
                        <a href="{{ route('opportunities.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة فرصة جديدة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العميل</th>
                                    <th>العنوان</th>
                                    <th>النوع</th>
                                    <th>المرحلة</th>
                                    <th>المبلغ</th>
                                    <th>احتمالية الإغلاق</th>
                                    <th>تاريخ الإغلاق المتوقع</th>
                                    <th>المستخدم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($opportunities as $opportunity)
                                    <tr>
                                        <td>{{ $opportunity->id }}</td>
                                        <td>
                                            <a href="{{ route('customers.show', $opportunity->customer_id) }}">
                                                {{ $opportunity->customer->name }}
                                            </a>
                                        </td>
                                        <td>{{ $opportunity->title }}</td>
                                        <td>
                                            @switch($opportunity->type)
                                                @case('new_sale')
                                                    <span class="badge bg-primary">بيع جديد</span>
                                                    @break
                                                @case('upgrade')
                                                    <span class="badge bg-success">ترقية</span>
                                                    @break
                                                @case('maintenance')
                                                    <span class="badge bg-info">صيانة</span>
                                                    @break
                                                @case('consultation')
                                                    <span class="badge bg-secondary">استشارة</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-dark">أخرى</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            @switch($opportunity->stage)
                                                @case('lead')
                                                    <span class="badge bg-secondary">عميل محتمل</span>
                                                    @break
                                                @case('qualified')
                                                    <span class="badge bg-info">مؤهل</span>
                                                    @break
                                                @case('proposal')
                                                    <span class="badge bg-primary">عرض سعر</span>
                                                    @break
                                                @case('negotiation')
                                                    <span class="badge bg-warning">تفاوض</span>
                                                    @break
                                                @case('closed_won')
                                                    <span class="badge bg-success">مغلق (ناجح)</span>
                                                    @break
                                                @case('closed_lost')
                                                    <span class="badge bg-danger">مغلق (خاسر)</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>{{ number_format($opportunity->amount, 2) }}</td>
                                        <td>{{ $opportunity->probability }}%</td>
                                        <td>{{ $opportunity->expected_close_date ? $opportunity->expected_close_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        <td>{{ $opportunity->user->name }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('opportunities.show', $opportunity->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('opportunities.edit', $opportunity->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('opportunities.destroy', $opportunity->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه الفرصة؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد فرص تجارية</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $opportunities->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection