@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إضافة فرصة تجارية جديدة</h5>
                    <a href="{{ route('opportunities.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('opportunities.store') }}">
                        @csrf

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">العميل <span class="text-danger">*</span></label>
                                    <select class="form-control @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">-- اختر العميل --</option>
                                        @foreach($customers as $customerItem)
                                            <option value="{{ $customerItem->id }}" {{ (old('customer_id', $customer_id ?? '') == $customerItem->id) ? 'selected' : '' }}>
                                                {{ $customerItem->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">عنوان الفرصة <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">وصف الفرصة</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">نوع الفرصة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('type') is-invalid @enderror" id="type" name="type" required>
                                        <option value="">-- اختر النوع --</option>
                                        <option value="new_sale" {{ old('type') == 'new_sale' ? 'selected' : '' }}>بيع جديد</option>
                                        <option value="upgrade" {{ old('type') == 'upgrade' ? 'selected' : '' }}>ترقية</option>
                                        <option value="maintenance" {{ old('type') == 'maintenance' ? 'selected' : '' }}>صيانة</option>
                                        <option value="consultation" {{ old('type') == 'consultation' ? 'selected' : '' }}>استشارة</option>
                                        <option value="other" {{ old('type') == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="stage">مرحلة الفرصة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('stage') is-invalid @enderror" id="stage" name="stage" required>
                                        <option value="">-- اختر المرحلة --</option>
                                        <option value="lead" {{ old('stage') == 'lead' ? 'selected' : '' }}>عميل محتمل</option>
                                        <option value="qualified" {{ old('stage') == 'qualified' ? 'selected' : '' }}>مؤهل</option>
                                        <option value="proposal" {{ old('stage') == 'proposal' ? 'selected' : '' }}>عرض سعر</option>
                                        <option value="negotiation" {{ old('stage') == 'negotiation' ? 'selected' : '' }}>تفاوض</option>
                                        <option value="closed_won" {{ old('stage') == 'closed_won' ? 'selected' : '' }}>مغلق (ناجح)</option>
                                        <option value="closed_lost" {{ old('stage') == 'closed_lost' ? 'selected' : '' }}>مغلق (خاسر)</option>
                                    </select>
                                    @error('stage')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="amount">المبلغ</label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount') }}">
                                    @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="probability">احتمالية الإغلاق (%)</label>
                                    <input type="number" min="0" max="100" class="form-control @error('probability') is-invalid @enderror" id="probability" name="probability" value="{{ old('probability') }}">
                                    @error('probability')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="expected_close_date">تاريخ الإغلاق المتوقع</label>
                                    <input type="date" class="form-control @error('expected_close_date') is-invalid @enderror" id="expected_close_date" name="expected_close_date" value="{{ old('expected_close_date') }}">
                                    @error('expected_close_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="source">مصدر الفرصة</label>
                                    <input type="text" class="form-control @error('source') is-invalid @enderror" id="source" name="source" value="{{ old('source') }}">
                                    @error('source')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="loss_reason">سبب الخسارة (في حالة الإغلاق الخاسر)</label>
                                    <input type="text" class="form-control @error('loss_reason') is-invalid @enderror" id="loss_reason" name="loss_reason" value="{{ old('loss_reason') }}">
                                    @error('loss_reason')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ
                                </button>
                                <a href="{{ route('opportunities.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection