@extends('layouts.modern')

@section('title', 'الإشعارات العاجلة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الإشعارات العاجلة والحرجة</h5>
                    <div>
                        <a href="{{ route('notifications.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للإشعارات
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>تنبيه:</strong> هذه القائمة تعرض الإشعارات العاجلة والحرجة التي تتطلب اهتماماً فورياً.
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>العنوان</th>
                                    <th>النوع</th>
                                    <th>الأولوية</th>
                                    <th>الحالة</th>
                                    <th>التاريخ</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($urgentNotifications ?? [] as $notification)
                                    <tr class="{{ $notification->read_at ? '' : 'table-primary' }} {{ $notification->priority == 'high' ? 'table-warning' : '' }} {{ $notification->priority == 'critical' ? 'table-danger' : '' }}">
                                        <td>
                                            <a href="{{ route('notifications.show', $notification->id) }}" class="fw-bold">
                                                {{ $notification->title }}
                                            </a>
                                            <div class="small text-muted">{{ Str::limit($notification->message, 60) }}</div>
                                        </td>
                                        <td>
                                            @if ($notification->type == 'maintenance_urgent')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-exclamation-circle"></i> صيانة عاجلة
                                                </span>
                                            @elseif ($notification->type == 'maintenance_overdue')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-exclamation-triangle"></i> صيانة متأخرة
                                                </span>
                                            @elseif ($notification->type == 'maintenance_critical_overdue')
                                                <span class="badge bg-danger" style="background-color: #d9534f !important;">
                                                    <i class="fas fa-radiation"></i> صيانة متأخرة بشكل حرج
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">{{ $notification->type }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($notification->priority == 'high')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-exclamation-circle"></i> عالية
                                                </span>
                                            @elseif ($notification->priority == 'critical')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-radiation"></i> حرجة
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($notification->read_at)
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check"></i> مقروء
                                                </span>
                                            @elseif ($notification->sent_at)
                                                <span class="badge bg-info">
                                                    <i class="fas fa-paper-plane"></i> تم الإرسال
                                                </span>
                                            @else
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-clock"></i> معلق
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            <span title="{{ $notification->created_at->format('Y-m-d H:i:s') }}">
                                                {{ $notification->created_at->diffForHumans() }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('notifications.show', $notification->id) }}" class="btn btn-sm btn-info" title="عرض التفاصيل">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if (!$notification->read_at)
                                                    <a href="{{ route('notifications.mark-read', $notification->id) }}" class="btn btn-sm btn-success" title="تحديد كمقروء">
                                                        <i class="fas fa-check"></i>
                                                    </a>
                                                @endif
                                                @php
                                                    $notificationData = [];
                                                    if ($notification->data) {
                                                        $notificationData = is_array($notification->data) ? $notification->data : json_decode($notification->data, true);
                                                        $notificationData = is_array($notificationData) ? $notificationData : [];
                                                    }
                                                @endphp
                                                
                                                @if (isset($notificationData['schedule_id']))
                                                    <a href="{{ route('maintenance-schedules.show', $notificationData['schedule_id']) }}" class="btn btn-sm btn-primary" title="عرض جدولة الصيانة">
                                                        <i class="fas fa-calendar-check"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">لا توجد إشعارات عاجلة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection